#  Copyright (C) 2009 ALT Linux Team.
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#  Contact information:
#
#  SMTP: devel [at] lists [dot] altlinux [dot] org
#

# Verborum Caterva -- simple engine for arbitrary file
# structure generation.
#
# Library for communication with Alterator backends.
#

# Prints an information message.
# args: message
print_info()
{
    [ "$CATERVA_VERBOSE" -ne 0 ] &&
    echo "[$CATERVA_TEMPLATE] $1" 1>&2
}

# Inverts line grouping in the Alterator-cmdline output
reformat()
{
    local ln=
    read ln
    [ -z "$ln" ] || echo "$ln"
    cat
    echo
}

# Binds an Alterator object properties data as it
# is outputted by the alterator-cmdline utility to
# variables and executes a function with a
# specified name.
# args: function-name function-args...
on_object()
{
    local CATERVA_UNSET_EXP=   
    local handler="$1"
    shift
    reformat | while read ln; do
	res=0
	if [ -n "$ln" ]; then
	    CATERVA_ATTR_NAME=`echo "${ln%%:*}" | sed -s 's/-/_/g'`
	    CATERVA_ATTR_VAL="${ln#*:}"
	    if [ -n "$CATERVA_UNSET_EXP" ]; then
		CATERVA_UNSET_EXP="$CATERVA_UNSET_EXP; "
	    fi
	    CATERVA_UNSET_EXP="${CATERVA_UNSET_EXP}unset $CATERVA_ATTR_NAME"
	    eval "$CATERVA_ATTR_NAME=\"$CATERVA_ATTR_VAL\""
	else
	    if [ -n "$CATERVA_UNSET_EXP" ]; then
		"$handler" $*
		res=$?
		eval "$CATERVA_UNSET_EXP"
	    fi
	    CATERVA_UNSET_EXP=
	    [ "$res" -eq 0 ] || exit $res
	fi
    done
}
