#!/bin/sh

SNORT_CONFIG=/etc/snort/snort.conf
SERVICE=/sbin/service
CHKCONFIG=/sbin/chkconfig
MYSQL=/usr/bin/mysql
SNORT=/usr/sbin/snort
SYSCONFIG_FILE=/etc/sysconfig/snort

# '$' is not valid symbol in snort.conf
while [ -z "$pass" ] || echo "$pass" | grep -qs '\$'; do
    pass=`/usr/bin/pwqgen`
done

$SERVICE mysqld start

STATUS=1
i=0
while [ "$STATUS" != "0" ] && [ $i -lt 10 ]; do
    sleep 1
    i="$(($i+1))"
    echo "DROP DATABASE IF EXISTS snort;" | $MYSQL
    echo "CREATE DATABASE snort;" | $MYSQL
    STATUS=$?
done

snort_version="$($SNORT -V 2>&1 | sed -n 's;^.*Version \([1-9.]\+\).*$;\1;p')"
$MYSQL -D snort -u root </usr/share/doc/snort-$snort_version/create_mysql

echo "GRANT INSERT,SELECT on snort.* to snort@localhost identified by \"$pass\";" | $MYSQL snort
echo "GRANT INSERT,SELECT,UPDATE on snort.sensor to snort@localhost identified by \"$pass\";" | $MYSQL snort

sed -i "/^ADDPARAMS_any/d" "$SYSCONFIG_FILE"
sed -i "/## EOF ##/i\ADDPARAMS_any='-U -D -c $SNORT_CONFIG'" "$SYSCONFIG_FILE"

output_db_prefix_str='output database: alert, mysql, host=localhost user=snort'
output_database="$output_db_prefix_str password=$pass dbname=snort"
find_pattern="[[:blank:]]*$output_db_prefix_str password"
if grep -qs "^$find_pattern" "$SNORT_CONFIG"; then
    sed -i "s/^$find_pattern.*\$/$(echo "$output_database"|sed -e 's/[\"\`\\&]/\\&/g')/" "$SNORT_CONFIG"
else
    find_pattern='^#[[:blank:]]*output database: log, oracle,'
    if grep -qs "$find_pattern" "$SNORT_CONFIG"; then
        sed -i "/$find_pattern/a\\$(echo "$output_database"|sed -e 's/[\"\`\\&]/\\&/g')" "$SNORT_CONFIG"
    else
        echo "$output_database" >>"$SNORT_CONFIG"
    fi
fi

$SERVICE snortd condrestart ||:
