
# This file was created by mkconfig.rb when ruby was built.  Any
# changes made to this file will be lost the next time ruby is built.

module RbConfig
  RUBY_VERSION == "1.9.2" or
    raise "ruby lib version (1.9.2) doesn't match executable version (#{RUBY_VERSION})"

  TOPDIR = File.dirname(__FILE__).chomp!("/lib/ruby/1.9/arm-linux-gnueabi")
  DESTDIR = ENV['DESTDIR'].to_s unless defined? DESTDIR
  CONFIG = {}
  CONFIG["DESTDIR"] = DESTDIR
  CONFIG["MAJOR"] = "1"
  CONFIG["MINOR"] = "9"
  CONFIG["TEENY"] = "1"
  CONFIG["PATCHLEVEL"] = "188"
  CONFIG["INSTALL"] = '/bin/install -c'
  CONFIG["EXEEXT"] = ""
  CONFIG["prefix"] = (TOPDIR || DESTDIR + "/usr")
  CONFIG["ruby_install_name"] = "ruby"
  CONFIG["RUBY_INSTALL_NAME"] = "ruby"
  CONFIG["RUBY_SO_NAME"] = "ruby"
  CONFIG["PACKAGE"] = "ruby"
  CONFIG["BUILTIN_TRANSSRCS"] = " newline.c"
  CONFIG["MANTYPE"] = "doc"
  CONFIG["NROFF"] = "/usr/bin/nroff"
  CONFIG["vendorhdrdir"] = "$(DESTDIR)/usr/include/ruby/1.9/vendor_ruby"
  CONFIG["sitehdrdir"] = "$(DESTDIR)/usr/local/include/ruby/1.9/site_ruby"
  CONFIG["rubyhdrdir"] = "$(DESTDIR)/usr/include/ruby/1.9"
  CONFIG["UNIVERSAL_INTS"] = ""
  CONFIG["UNIVERSAL_ARCHNAMES"] = ""
  CONFIG["configure_args"] = " '--build=arm-alt-linux-gnueabi' '--host=arm-alt-linux-gnueabi' '--prefix=/usr' '--exec-prefix=/usr' '--bindir=/usr/bin' '--sbindir=/usr/sbin' '--sysconfdir=/etc' '--datadir=/usr/share' '--includedir=/usr/include' '--libdir=/usr/lib' '--libexecdir=/usr/lib' '--localstatedir=/var/lib' '--sharedstatedir=/usr/com' '--mandir=/usr/share/man' '--infodir=/usr/share/info' '--disable-dependency-tracking' '--without-included-gettext' '--enable-frame-address' '--enable-shared' '--disable-rpath' '--enable-pthread' '--with-rubylibprefix=/usr/share/ruby' '--with-rubyarchprefix=/usr/lib/ruby' '--with-rubyhdrdir=/usr/include/ruby/1.9' '--with-sitedir=/usr/local/share/ruby/site_ruby' '--with-sitearchprefix=/usr/local/lib/ruby/site_ruby' '--with-sitehdrdir=/usr/local/include/ruby/1.9/site_ruby' '--with-vendordir=/usr/share/ruby/vendor_ruby' '--with-vendorarchprefix=/usr/lib/ruby/vendor_ruby' '--with-vendorhdrdir=/usr/include/ruby/1.9/vendor_ruby' '--with-ridir=/usr/share/ri' '--with-ruby-version=minor' '--enable-ipv6' '--with-lookup-order-hack=INET' 'build_alias=arm-alt-linux-gnueabi' 'host_alias=arm-alt-linux-gnueabi' 'CFLAGS=-pipe -Wall -g -O2 -fomit-frame-pointer -march=armv5te' 'CXXFLAGS=-pipe -Wall -g -O2 -fomit-frame-pointer -march=armv5te'"
  CONFIG["vendorarchprefix"] = "$(DESTDIR)/usr/lib/ruby/vendor_ruby"
  CONFIG["vendordir"] = "$(DESTDIR)/usr/share/ruby/vendor_ruby"
  CONFIG["sitearchprefix"] = "$(DESTDIR)/usr/local/lib/ruby/site_ruby"
  CONFIG["sitedir"] = "$(DESTDIR)/usr/local/share/ruby/site_ruby"
  CONFIG["ruby_version"] = "1.9"
  CONFIG["sitearch"] = "arm-linux-gnueabi"
  CONFIG["arch"] = "arm-linux-gnueabi"
  CONFIG["RI_BASE_NAME"] = "ri"
  CONFIG["ridir"] = "$(DESTDIR)/usr/share/ri"
  CONFIG["rubyarchprefix"] = "$(DESTDIR)/usr/lib/ruby"
  CONFIG["rubylibprefix"] = "$(DESTDIR)/usr/share/ruby"
  CONFIG["MAKEFILES"] = "Makefile"
  CONFIG["THREAD_MODEL"] = "pthread"
  CONFIG["EXPORT_PREFIX"] = ""
  CONFIG["COMMON_HEADERS"] = ""
  CONFIG["COMMON_MACROS"] = ""
  CONFIG["COMMON_LIBS"] = ""
  CONFIG["MAINLIBS"] = ""
  CONFIG["ENABLE_SHARED"] = "yes"
  CONFIG["DLDLIBS"] = " -lc"
  CONFIG["SOLIBS"] = "$(LIBS)"
  CONFIG["LIBRUBYARG_SHARED"] = "-l$(RUBY_SO_NAME)"
  CONFIG["LIBRUBYARG_STATIC"] = "-l$(RUBY_SO_NAME)-static"
  CONFIG["LIBRUBYARG"] = "$(LIBRUBYARG_SHARED)"
  CONFIG["LIBRUBY"] = "$(LIBRUBY_SO)"
  CONFIG["LIBRUBY_ALIASES"] = "lib$(RUBY_SO_NAME).so.$(MAJOR).$(MINOR) lib$(RUBY_SO_NAME).so"
  CONFIG["LIBRUBY_SO"] = "lib$(RUBY_SO_NAME).so.$(MAJOR).$(MINOR).$(TEENY)"
  CONFIG["LIBRUBY_A"] = "lib$(RUBY_SO_NAME)-static.a"
  CONFIG["RUBYW_INSTALL_NAME"] = ""
  CONFIG["rubyw_install_name"] = ""
  CONFIG["LIBRUBY_DLDFLAGS"] = "-Wl,-soname,lib$(RUBY_SO_NAME).so.$(MAJOR).$(MINOR)"
  CONFIG["LIBRUBY_LDSHARED"] = "$(CC) -shared"
  CONFIG["warnflags"] = "-Wextra -Wno-unused-parameter -Wno-parentheses -Wpointer-arith -Wwrite-strings -Wno-missing-field-initializers -Wno-long-long"
  CONFIG["debugflags"] = "-ggdb"
  CONFIG["optflags"] = " "
  CONFIG["cxxflags"] = " $(optflags) $(debugflags) $(warnflags)"
  CONFIG["cflags"] = " $(optflags) $(debugflags) $(warnflags)"
  CONFIG["cppflags"] = ""
  CONFIG["INSTALLDOC"] = "all"
  CONFIG["RDOCTARGET"] = "rdoc"
  CONFIG["EXECUTABLE_EXTS"] = ""
  CONFIG["ARCHFILE"] = ""
  CONFIG["EXTOUT"] = ".ext"
  CONFIG["PREP"] = "miniruby$(EXEEXT)"
  CONFIG["TEST_RUNNABLE"] = "yes"
  CONFIG["setup"] = "Setup"
  CONFIG["EXTSTATIC"] = ""
  CONFIG["STRIP"] = "strip -S -x"
  CONFIG["TRY_LINK"] = ""
  CONFIG["LIBPATHENV"] = "LD_LIBRARY_PATH"
  CONFIG["RPATHFLAG"] = ""
  CONFIG["LIBPATHFLAG"] = " -L%s"
  CONFIG["LINK_SO"] = ""
  CONFIG["LIBEXT"] = "a"
  CONFIG["DLEXT2"] = ""
  CONFIG["DLEXT"] = "so"
  CONFIG["LDSHAREDXX"] = "$(CXX) -shared"
  CONFIG["LDSHARED"] = "$(CC) -shared"
  CONFIG["CCDLFLAGS"] = "-fPIC"
  CONFIG["STATIC"] = ""
  CONFIG["ARCH_FLAG"] = ""
  CONFIG["DLDFLAGS"] = ""
  CONFIG["ALLOCA"] = ""
  CONFIG["CHDIR"] = "cd -P"
  CONFIG["RMALL"] = "rm -fr"
  CONFIG["RMDIRS"] = "$(top_srcdir)/tool/rmdirs"
  CONFIG["CP"] = "cp"
  CONFIG["RM"] = "rm -f"
  CONFIG["CAPITARGET"] = "nodoc"
  CONFIG["DOXYGEN"] = ""
  CONFIG["DOT"] = ""
  CONFIG["MAKEDIRS"] = "/bin/mkdir -p"
  CONFIG["MKDIR_P"] = "/bin/mkdir -p"
  CONFIG["INSTALL_DATA"] = "$(INSTALL) -m 644"
  CONFIG["INSTALL_SCRIPT"] = "$(INSTALL)"
  CONFIG["INSTALL_PROGRAM"] = "$(INSTALL)"
  CONFIG["SET_MAKE"] = ""
  CONFIG["LN_S"] = "ln -s"
  CONFIG["DLLWRAP"] = ""
  CONFIG["WINDRES"] = ""
  CONFIG["NM"] = ""
  CONFIG["OBJCOPY"] = "objcopy"
  CONFIG["OBJDUMP"] = "objdump"
  CONFIG["ASFLAGS"] = ""
  CONFIG["AS"] = "as"
  CONFIG["AR"] = "ar"
  CONFIG["RANLIB"] = "ranlib"
  CONFIG["try_header"] = ""
  CONFIG["COUTFLAG"] = "-o "
  CONFIG["OUTFLAG"] = "-o "
  CONFIG["CPPOUTFILE"] = "-o conftest.i"
  CONFIG["GNU_LD"] = "yes"
  CONFIG["GCC"] = "yes"
  CONFIG["EGREP"] = "/bin/grep -E"
  CONFIG["GREP"] = "/bin/grep"
  CONFIG["CPP"] = "$(CC) -E"
  CONFIG["CXXFLAGS"] = "-pipe -Wall -g -O2 -fomit-frame-pointer -march=armv5te"
  CONFIG["CXX"] = "g++"
  CONFIG["OBJEXT"] = "o"
  CONFIG["CPPFLAGS"] = " $(DEFS) $(cppflags)"
  CONFIG["LDFLAGS"] = "-L.  -rdynamic -Wl,-export-dynamic"
  CONFIG["CFLAGS"] = "-pipe -Wall -g -O2 -fomit-frame-pointer -march=armv5te -fPIC"
  CONFIG["CC"] = "arm-alt-linux-gnueabi-gcc"
  CONFIG["target_os"] = "linux-gnueabi"
  CONFIG["target_vendor"] = "alt"
  CONFIG["target_cpu"] = "arm"
  CONFIG["target"] = "arm-alt-linux-gnueabi"
  CONFIG["host_os"] = "linux-gnueabi"
  CONFIG["host_vendor"] = "alt"
  CONFIG["host_cpu"] = "arm"
  CONFIG["host"] = "arm-alt-linux-gnueabi"
  CONFIG["build_os"] = "linux-gnueabi"
  CONFIG["build_vendor"] = "alt"
  CONFIG["build_cpu"] = "arm"
  CONFIG["build"] = "arm-alt-linux-gnueabi"
  CONFIG["RUBYW_BASE_NAME"] = "rubyw"
  CONFIG["RUBY_BASE_NAME"] = "ruby"
  CONFIG["RUBY_RELEASE_DATE"] = "2011-03-28"
  CONFIG["RUBY_PROGRAM_VERSION"] = "1.9.2"
  CONFIG["BASERUBY"] = "ruby"
  CONFIG["target_alias"] = ""
  CONFIG["host_alias"] = "arm-alt-linux-gnueabi"
  CONFIG["build_alias"] = "arm-alt-linux-gnueabi"
  CONFIG["LIBS"] = "-lpthread -lrt -ldl -lcrypt -lm "
  CONFIG["ECHO_T"] = ""
  CONFIG["ECHO_N"] = "-n"
  CONFIG["ECHO_C"] = ""
  CONFIG["DEFS"] = "-D_FILE_OFFSET_BITS=64"
  CONFIG["mandir"] = "$(DESTDIR)/usr/share/man"
  CONFIG["localedir"] = "$(datarootdir)/locale"
  CONFIG["libdir"] = "$(DESTDIR)/usr/lib"
  CONFIG["psdir"] = "$(docdir)"
  CONFIG["pdfdir"] = "$(docdir)"
  CONFIG["dvidir"] = "$(docdir)"
  CONFIG["htmldir"] = "$(docdir)"
  CONFIG["infodir"] = "$(DESTDIR)/usr/share/info"
  CONFIG["docdir"] = "$(datarootdir)/doc/$(PACKAGE)"
  CONFIG["oldincludedir"] = "/usr/include"
  CONFIG["includedir"] = "$(DESTDIR)/usr/include"
  CONFIG["localstatedir"] = "$(DESTDIR)/var/lib"
  CONFIG["sharedstatedir"] = "$(DESTDIR)/usr/com"
  CONFIG["sysconfdir"] = "$(DESTDIR)/etc"
  CONFIG["datadir"] = "$(DESTDIR)/usr/share"
  CONFIG["datarootdir"] = "$(prefix)/share"
  CONFIG["libexecdir"] = "$(DESTDIR)/usr/lib"
  CONFIG["sbindir"] = "$(DESTDIR)/usr/sbin"
  CONFIG["bindir"] = "$(DESTDIR)/usr/bin"
  CONFIG["exec_prefix"] = "/usr"
  CONFIG["PACKAGE_URL"] = ""
  CONFIG["PACKAGE_BUGREPORT"] = ""
  CONFIG["PACKAGE_STRING"] = ""
  CONFIG["PACKAGE_VERSION"] = ""
  CONFIG["PACKAGE_TARNAME"] = ""
  CONFIG["PACKAGE_NAME"] = ""
  CONFIG["PATH_SEPARATOR"] = ":"
  CONFIG["SHELL"] = "/bin/sh"
  CONFIG["rubylibdir"] = "$(rubylibprefix)/$(ruby_version)"
  CONFIG["archdir"] = "$(rubyarchprefix)/$(ruby_version)/$(arch)"
  CONFIG["sitelibdir"] = "$(sitedir)/$(ruby_version)"
  CONFIG["sitearchdir"] = "$(sitearchprefix)/$(ruby_version)/$(sitearch)"
  CONFIG["vendorlibdir"] = "$(vendordir)/$(ruby_version)"
  CONFIG["vendorarchdir"] = "$(vendorarchprefix)/$(ruby_version)/$(sitearch)"
  if defined?(VENDOR_SPECIFIC) && VENDOR_SPECIFIC
    CONFIG["sitedir"] = "$(vendordir)"
    CONFIG["sitelibdir"] = "$(vendorlibdir)"
    CONFIG["sitearchdir"] = "$(vendorarchdir)"
    CONFIG["sitehdrdir"] = "$(vendorhdrdir)"
  end
  CONFIG["topdir"] = File.dirname(__FILE__)
  MAKEFILE_CONFIG = {}
  CONFIG.each{|k,v| MAKEFILE_CONFIG[k] = v.dup}
  def RbConfig::expand(val, config = CONFIG)
    newval = val.gsub(/\$\$|\$\(([^()]+)\)|\$\{([^{}]+)\}/) {
      var = $&
      if !(v = $1 || $2)
	'$'
      elsif key = config[v = v[/\A[^:]+(?=(?::(.*?)=(.*))?\z)/]]
	pat, sub = $1, $2
	config[v] = false
	config[v] = RbConfig::expand(key, config)
	key = key.gsub(/#{Regexp.quote(pat)}(?=\s|\z)/n) {sub} if pat
	key
      else
	var
      end
    }
    val.replace(newval) unless newval == val
    val
  end
  CONFIG.each_value do |val|
    RbConfig::expand(val)
  end

  # returns the absolute pathname of the ruby command.
  def RbConfig.ruby
    File.join(
      RbConfig::CONFIG["bindir"],
      RbConfig::CONFIG["ruby_install_name"] + RbConfig::CONFIG["EXEEXT"]
    )
  end
end
Config = RbConfig # compatibility for ruby-1.8.4 and older.
CROSS_COMPILING = nil unless defined? CROSS_COMPILING
