LIBRARY = $(shell basename $(shell pwd))

SHAREDLIB = $(LIBRARY).so
SONAME = $(SHAREDLIB).$(SO_MAJOR)

prefix = $(RPM_BUILD_ROOT)
libdir = $(prefix)/usr/lib

ifeq ($(MODE),C)

OBJ_EXT=c
CFLAGS += -I../../include $(RPM_OPT_FLAGS) -fpic 
COMPILLER=$(CC)
COMPILLER_FLAGS=$(CFLAGS)
else

OBJ_EXT=cc
CXXFLAGS += -I../../include $(RPM_OPT_FLAGS) -fpic 
COMPILLER=$(CXX)
COMPILLER_FLAGS=$(CXXFLAGS)
endif

LDLIBS += -lguile 

LINKER = $(COMPILLER) $(LDFLAGS) $(TARGET_ARCH)

LIB_SRC += $(wildcard *.$(OBJ_EXT))

#use sort to remove possible duplicates
LIB_OBJ = $(sort $(LIB_SRC:%.$(OBJ_EXT)=%.o))
LIB_DEP = $(sort $(LIB_SRC:%.$(OBJ_EXT)=%.d))

TARGETS = $(SHAREDLIB)

.PHONY: all install clean

all: $(TARGETS)

$(SHAREDLIB): $(LIB_OBJ)
	echo $(LIB_SRC)
	$(LINKER) -shared -Wl,-soname,$(SONAME) $+ $(LDLIBS) $(OUTPUT_OPTION)
	ln -sf $(SHAREDLIB) $(SONAME)

clean:
	$(RM) $(TARGETS) $(LIB_OBJ) $(LIB_DEP) $(SONAME) $(LIB_CLEAN) core *~

install: all
	install -pD -m755 $(SHAREDLIB) $(libdir)/$(SHAREDLIB).$(SO_VERSION)
	@ln -sf $(SHAREDLIB).$(SO_VERSION) $(libdir)/$(SONAME)
	@ln -sf $(SONAME) $(libdir)/$(SHAREDLIB)

# We need dependencies only if goal isn't "clean"
ifneq ($(MAKECMDGOALS),clean)

%.d:	%.$(OBJ_EXT)
	@echo Making dependences for $<
	@$(SHELL) -ec "$(COMPILLER) -MM $(COMPILLER_FLAGS) $< | sed 's|\($*\)\.o[ :]*|\1.o $@ : |g' > $@; [ -s $@ ] || $(RM) $@"

ifneq ($(LIB_DEP),)
-include $(LIB_DEP)
endif
endif
