#this two lines should be removed after merge po.mak into module.mak
.EXPORT_ALL_VARIABLES:
SDK_DIR ?= /usr/share/alterator/build

PO_NAME ?= alterator-$(NAME)
PO_TEMPLATE ?= po/$(PO_NAME).pot
PO_KEYWORD ?= _

PO_XGETTEXT_DIR=$(SDK_DIR)/xgettext
PO_MSGFMT_DIR=$(SDK_DIR)/msgfmt

PO_LOCALE_DIR=$(datadir)/locale
PO_DICTIONARY_FILES= $(wildcard /usr/share/alterator/l10n/*.po)
PO_FILES=$(wildcard po/*.po)
PO_LANGUAGES=$(sort $(PO_FILES:po/%.po=%) $(PO_DICTIONARY_FILES:/usr/share/alterator/l10n/%.po=%))

ALTERATOR_L10NDIR=/usr/share/alterator/l10n

merge-po:
	[ ! -f $(ALTERATOR_L10NDIR)/alterator.pot ] || make update-po || :
	for i in $(PO_LANGUAGES); do \
	    msgmerge $(ALTERATOR_L10NDIR)/$$i.po $(PO_TEMPLATE) -o po/$$i.po || :; \
	done

install-po: merge-po
	for i in $(PO_MSGFMT_DIR)/*;do $$i ; done

update-po:
	mkdir -p -- po
	$(RM) $(PO_TEMPLATE)
	touch $(PO_TEMPLATE)
	for i in $(PO_XGETTEXT_DIR)/*;do $$i ;done
	for i in $(PO_LANGUAGES);do \
	[ ! -s po/$$i.po ] || msgmerge -U po/$$i.po $(PO_TEMPLATE); \
	done || :

clean-po:
	$(RM) po/*.mo po/*.po~
