jQuery.fn.serializeAll = function() {
    return jQuery.param(this.serializeArrayAll());
}

jQuery.fn.serializeArrayAll = function() {
    return this.map(function(){
		return jQuery.nodeName(this, "form") ?
			    jQuery.makeArray(this.elements) : this;})
		.filter(function(){
			return this.name &&
				(this.checked || /select|textarea/i.test(this.nodeName) ||
					/text|hidden|password/i.test(this.type));
		})
		.map(function(i, elem){
			var val = jQuery(this).val();
			return val == null ? null :
				val.constructor == Array ?
					jQuery.map( val, function(val, i){
						return {name: elem.name, value: val};
					}) :
					{name: elem.name, value: val};
		}).get();
}

function form_ajax_lock()
{
    $.blockUI({ message: '<img class="alterator-splash" src="/design/images/loading.gif"/>',
		fadeIn: 0,
		fadeOut: 0,
		overlayCSS: { opacity: 0 },
		css : { border: 'none', background: 'none'}});
}

function form_ajax_unlock()
{
    $.unblockUI();
}

function form_ajax(id,data,path,async)
{
	var is_async = async || false;
	//reconstruct url: document.location.href can contain broken url, e.g. with ? at the end
	if (!path){
	    with (document.location)
		path = protocol + '//' + host + pathname + search
	}

	path=path + ((path.indexOf('?') == -1)?'?':'&') + 'ajax='+id+'&msienocache='+ Math.random();

	if (!is_async) form_ajax_lock();
	return jQuery.ajax({
		    type: 'POST',
		    async: true,
		    url: path,
		    data: data,
		    dataType: 'text',
		    success: function(data) {
				if (!is_async) form_ajax_unlock() ;
				eval(data);
				},
		    error: function(xhr, status, expt) {
				if (is_async) return; /* async calls are silent and without lock */
				form_message({ title: '',
				         msg: 'Async request failed<br/>'+
				              '<strong>Request status</strong>:&nbsp;'+status+'<br/>'+
				              '<strong>Response</strong>:&nbsp;'+xhr.responseText});
				form_ajax_unlock() ;
				}
		});
}


function form_callback(id,form,path,async)
{
    form_ajax(id,
              form? $(form).serializeAll():$('form').serializeAll(),
              path,
              async);
}

function form_upload(id,filefieldname,form)
{
    var path='';
    with (document.location)
        path = protocol + '//' + host + pathname + search

    path= path + ((path.indexOf('?') == -1)?'?':'&') + 'ajax='+id+'&msienocache='+ Math.random();

    form_ajax_lock();
     $.ajaxFileUpload({ url: path,
                        dataType: 'text',
                        data: $(form).serializeArrayAll(),
                        fileElement: $('[name='+filefieldname+']'),
                        success: function(data,status) {
					    form_ajax_unlock();
					    eval(data);
				 }
			//errors unsupported in iframe objects
		     });
}

function form_bind(name,event,id)
{
    var elt = $('input,select,textarea,img').filter('[name='+name+']');
    if (elt.length == 0) return;

    if (event == "enter")
	elt.bind("keypress", function(event) {
	    if (event.keyCode == 13) form_callback(id,elt[0].form);});
    else
	elt.bind( event, function() { form_callback(id,elt[0].form); });
}

function form_bind_upload(name,event,filefieldname,id)
{
    var elt = $('input,select,textarea').filter('[name='+name+']');
    if (elt.length == 0) return;

    elt.bind(event, function() { form_upload(id,filefieldname,elt[0].form); });
}


function form_bind_timeedit(name,id)
{
    var __interval = 15000;
    function __sync_timeedit(elt,id)
    {
	if (elt.clock && !elt.clock.frozen)
	    form_callback(id,null,null,true);
	setTimeout(function(){__sync_timeedit(elt, id);}, __interval);
    }

    $('input.alterator-timeedit[type=text][name='+name+']').each(function(){
	if (this.clock) __sync_timeedit(this, id); });
}

function form_set_timeout(id, ms)
{
    setTimeout(function() { form_callback(id, null, null, true); }, ms);
}

jQuery.fn.resetOptions = function (data)
{
    return this.each(function(i)
    {
	var elt=$(this);

	elt.empty();
	for (var i=0;i<data.length;++i)
	{
	    var name = data[i]["name"];
	    var label = data[i]["label"] || name;

	    elt.append('<option value="'+name+'">'+label+'</option>');
	}
    });
}

jQuery.fn.resetInputListRows = function (type,data)
{
    return this.each(function(i)
    {
	var elt=$(this);
	var elt_name=$(this).attr('name');

	elt.empty();
	for (var i=0;i<data.length;++i)
	{
	    var name = data[i]["name"];
	    var label = data[i]["label"] || name;
	    elt.append($('<tr><td><input type="'+type+'" name="'+elt_name+'" value="'+name+'"></td><td align="left">'+label+'</td></tr>'));
	}
    });
}

jQuery.fn.resetListRows= function (data)
{
    return this.each(function(i)
    {
	var is_multi_select = $(this).hasClass('multi-select');
	var is_single_select = $(this).hasClass('single-select');
	var is_editable = $(this).hasClass('editable');
	var is_tree  = $(this).hasClass('alterator-tree');
	var name=$(this).attr('name');
	var tbody = $('tbody',this);
	var thead = $('thead',this);
	//clear table, prepare template row
	var row=$('tr:last',tbody).clone().hide();
	var dynamic_class=row.attr('alterator-class');
	tbody.empty();
	//append new tables
	for (i in data)
	{
	    var new_row = form_update_value_list(data[i],row.clone().show());
	    if (dynamic_class && data[i][dynamic_class])
		new_row.addClass(data[i][dynamic_class]);
	    if (is_multi_select)
		$('td:first input.select',new_row).
		    attr('name',name).
		    attr('value',data[i]['name']).
		    each(function() { this.checked = false; }).
		    bind('update-value change', function() { $(this).closest('tr').toggleClass('selected',this.checked); });
	    if (is_editable)
		$('td:first input.select',new_row).
		    attr('value',data[i]['name']);
	    if (is_single_select)
	    {
		$('td:first input.select',new_row).
		    attr('name',name).
		    attr('value',data[i]['name']).
		    bind('update-value', function() {
				$(this).
				    closest('tr').
				    focus().
				    toggleClass('selected',this.checked); });
		$('td',new_row).
		   click(function() {
				    var input = $(this).
						    closest('tr').
						    find('input.select').
						    each(function() { this.checked = true; });
				    $(this).closest('table').
				        find('input.select').
					trigger('update-value');
				    input.trigger('change');
				    });
	    }
	    tbody.append(new_row);
	}
	tbody.append(row);

	if (is_multi_select)
	    $('thead tr th input.select').each(function() { this.checked = false; });
	
	//notify tablesorter widget
	$(this).trigger('update');
	$(this).trigger('applyWidgets');
    });
}

function form_update_enum(name,data)
{
    $('select[name='+name+']').resetOptions(data);
    $('table.alterator-checklistbox[name='+name+']').resetInputListRows('checkbox',data);
    $('table.alterator-radiolistbox[name='+name+']').resetInputListRows('radio',data);
    $('table.alterator-listbox[name='+name+']').resetListRows(data);
}

jQuery.fn.updateValue = function(v)
{
    return this.each(function(i){
			var self = $(this);
			var v1 = v;
			if (/radio|checkbox/.test(this.type))
			    v1 = v.split(";");
			self.val(v1);
			self.trigger('update-value');
		    });
}

jQuery.fn.updateImageSource = function(v)
{
    return this.each(function(i){
	var prefix = $(this).attr('prefix-src') || "/design/images/";
	var suffix = $(this).attr('suffix-src') || "";
	var src = prefix + v + suffix;
	this.src = src + ((src.indexOf('?') == -1)?'?':'&') + 'nocache='+ Math.random(); });
}

jQuery.fn.updateHref = function(v)
{
    return this.each(function(i){
	var prefix = $(this).attr('prefix-href') || "";
	var suffix = $(this).attr('suffix-href') || "";
	this.href = prefix+encodeURIComponent(v)+suffix;
	});
}

function form_update_value(name,value,root)
{
    var root = root || document;

    $('input,select,textarea',root).filter('[name='+name+']').updateValue(value);
    $('span.alterator-label[name='+name+']',root).text(value);
    $('div.alterator-progress[name='+name+']',root).progressbar('value',value);
    $('img.alterator-picture[name='+name+']',root).updateImageSource(value);
    $('img.alterator-img[name='+name+']',root).updateImageSource(value);
    $('a.alterator-href[name='+name+']',root).updateHref(value);
}

function form_update_value_list(data,root)
{
    var root = root || document;
    for (i in data)
	form_update_value(i,data[i],root);
    return root;
}


function form_replace(path)
{
    document.location = path;
}

function form_replace_if_ready(path, sec)
{
    var msec = sec * 1000;
    setTimeout(function() {
		    jQuery.ajax({
			type: 'GET',
			async: true,
			url: path,
			dataType: 'text',
			success: function(data) { document.location = path; },
			error: function(xhr, status, expt) { form_replace_if_ready(path,2); }
		    });},
		msec);
}

function form_update_visibility(name,status)
{
    $("[name="+name+"],span[nameref="+name+"]").
	toggle(status);
}

function form_update_activity(name,status)
{
    $("[name="+name+"],span[nameref="+name+"]").
	toggleClass('ui-state-disabled',!status).
	each(function() { this.disabled = !status; });
}

function form_message(opts)
{
    $('<p id="_form_message_popup">'+opts.msg+'</p>').dialog({
				title: opts.title,
				bgiframe: true,
				modal: true,
				closeOnEscape: false,
				resizable: false,
				width: 400,
				buttons: { 'OK': function() {
						    $(this).dialog('destroy');
						    $('#_form_message_popup').remove();}}
			     });
}

function form_confirm(id,opts)
{
    var result='#f';
    var button_list={};
    button_list[opts.okButton]=function() { result='#t'; $(this).dialog('close',true); };
    button_list[opts.cancelButton]=function() { result='#f'; $(this).dialog('close',true); };

    $('<p id="_form_confirm_popup">'+opts.msg+'</p>').dialog({
				title: opts.title,
				bgiframe: true,
				modal: true,
				closeOnEscape: false,
				resizable: false,
				width: 400,
				buttons: button_list,
				close: function() {
					$(this).dialog('destroy');
					$('#_form_confirm_popup').remove();
					form_ajax(id,{retcode: result }); }
			     });
}

function form_type_error(reasonlist)
{
    var m=[];
    for (var name in reasonlist)
    {
	    var label=$('span[nameref='+name+']').text();
	    if (!label) label=$('span[name='+name+']').text();
	    if (!label) label=name+':';
	    m.push('<strong>'+label+'</strong>&nbsp;'+ reasonlist[name]);
    }

    form_message({ msg: m.join('<br/>'), title: ''});
}

function form_update_cookie(name,value)
{
    $.cookie(name, value?value:null, { expires: new Date(2038, 0, 18) , path: '/' });
}

// initialization
$(document).ready(function() {
    //widgets construction
    $('input.alterator-colorpicker').colorpicker();

    $('table.alterator-listbox').each(function(index){
	var self=$(this);
	var first_row = false;
	if (self.hasClass('single-select')) {
	    $('thead tr',this).prepend('<th style="display:none">&nbsp;</th>');
	    $('tbody tr',this).prepend('<td style="display:none"><input class="select" type="radio"/></td>');
	    first_row = true;
	} else if (self.hasClass('multi-select')) {
	    $('thead tr',this).prepend('<th><input class="select" type="checkbox"/></th>');
	    $('tbody tr',this).prepend('<td><input class="select" type="checkbox"/></td>');
	    $('thead tr th input.select').change(function(){
		var state = this.checked;
		$(this).
		closest('table').
		find('tbody tr td input.select').
		    each(function() { this.checked = state; }).
		    trigger('update-value'); });
	    first_row = true;
	}else if (self.hasClass('editable')) {
	    var name =self.attr('name');
	    // Entry creation
	    $('tfoot tr',this).prepend('<td><input id="del_btn" class="btn" type="button" value="Delete" name="del_line"></td>');
	    $('tfoot tr',this).append('<td align="right">\
	    <input disabled="disabled" id="sav_btn" class="btn disabled" type="button" value="Save" name="save_line">&nbsp;\
	    <span translate="_">New Value:</span>&nbsp;\
	    <input type="text" style="width:150px;" class="text" name="new_line"/></td>');
	    $('tfoot tr',this).append('<td><input  id="add_btn" class="btn" type="button" value="Add" name="add_line"></td>');
	    $('tbody tr:last',this).prepend('<td><input class="select" type="checkbox" name="'+name+'"></td>');
	    $('tbody tr:last',this).append('<td><input id="edit_btn" class="btn" type="button" value="Edit" name="edit_line"></td>');
	    // Functions
	    $('tfoot tr td #del_btn',this).live("click", function(){
		$('tbody tr td input:checkbox').each(function() { 
		   if (this.checked) $(this.parentNode.parentNode).remove();
		});
	    });
	    $('tbody tr td #edit_btn', this).live("click", function(){
	       $('tbody > tr:gt(1) td .select').each(function() { 
		   if (this.checked) {this.checked = false; }
		});
	       $(this).parent().siblings().find('.select').attr('checked', 'checked');
	       $('tfoot tr td .text',self).val($(this).parent().siblings().find('.select').val());
	       $(this).parent().siblings().find('span').fadeOut("fast");
	       $('tbody tr td').find('.select, #del_btn, #add_btn, #edit_btn').attr("disabled",true).addClass("disabled");
	       $('tfoot tr td').find('#sav_btn').attr("disabled",false).removeClass("disabled");
	    });
	    $('tfoot tr td #add_btn',this).live("click", function(){
	       if ( $('tfoot tr td .text',self).val() ) {
	         var row = $('tr:last',$('tbody',self)).clone();
	         row.children("td").find('.select').val( $('tfoot tr td .text',self).val());
	         row.children("td").find('.alterator-label').text( $('tfoot tr td .text',self).val());
	         row.insertBefore($('tbody tr:last',self)).show();
	         $('tfoot tr td .text',self).val("");
	       }else{
	         $('tfoot tr td .text',self).fadeOut("fast");
	         $('tfoot tr td .text',self).fadeIn("fast");
	       };
	    });
	    $('tfoot tr td #sav_btn', this).live("click", function(){
	       if ( $('tfoot tr td .text',self).val() ) {
	    	$('tbody tr td .select').each(function() { 
		   if (this.checked) {
		      $(this).val($('tfoot tr td .text',self).val() );
		      $(this).parent().siblings().find('span').text($('tfoot tr td .text',self).val() );
		      $(this).parent().siblings().find('span').fadeIn("fast");
		      $('tfoot tr td .text',self).val("");
		      $('tfoot tr td').find('#sav_btn').attr("disabled",true).addClass("disabled");
		      $('tbody tr td').find('.select, #del_btn, #add_btn, #edit_btn').attr("disabled",false).removeClass("disabled");
		      this.checked = false;
		   };
		 });
		}else{
	         $('tfoot tr td .text',self).fadeOut("fast");
	         $('tfoot tr td .text',self).fadeIn("fast");
	       };
	    });
	}
	self.tablesorter({ widgets: ["zebra"], headers: first_row?{0:{sorter: false}}:{} });
	});

    $('input[type=text].alterator-datepicker').datepicker();
    $('input[type=text].alterator-dateedit').dateedit();
    $('input[type=text].alterator-timeedit').timeedit();
    $('div.alterator-progress').progressbar();
    $('div.alterator-accordion').each(function(index){
					var self=$(this);
					self.accordion( {autoHeight: !self.hasClass('no-auto-height')} );
					});

    //standard help button
    $('#help-button').helpButton($('#main'),'/ahttpd/help');
    $('#logout-button').topButton('/logout');
    $('#configuration-button').topButton('/ahttpd/configuration');
});

function tree_toggle(event) {
	event = event || window.event
	var clickedElem = event.target || event.srcElement

	if (!hasClass(clickedElem, 'Expand')) {
		return // клик не там
	}

	// Node, на который кликнули
	var node = clickedElem.parentNode
	if (hasClass(node, 'ExpandLeaf')) {
		return // клик на листе
	}

	// определить новый класс для узла
	var newClass = hasClass(node, 'ExpandOpen') ? 'ExpandClosed' : 'ExpandOpen'
	// заменить текущий класс на newClass
	// регексп находит отдельно стоящий open|close и меняет на newClass
	var re =  /(^|\s)(ExpandOpen|ExpandClosed)(\s|$)/
	node.className = node.className.replace(re, '$1'+newClass+'$3')
}


function hasClass(elem, className) {
	return new RegExp("(^|\\s)"+className+"(\\s|$)").test(elem.className)
}

