(define-module (alterator ahttpd acl)
  :use-module (srfi srfi-1)
  :use-module (alterator ahttpd)
  :export (make-acl
           acl-check))

(define (make-acl config-lines)
  (map (lambda(x)
	 (cons (car x)
	       (string-split (cdr x) #\,)))
       config-lines))

(define (acl-find acl uri)
  (or (any (lambda(x)
	     (and (uri-prefix? (car x) uri)
		  (cdr x)))
	   acl)
      '("root")))

(define (acl-check acl uri user)
  (or (string=? uri "/")
      (member user (acl-find acl uri))))
