(define-module (alterator ahttpd response)
  :use-module (alterator algo)

  :use-module (vhttpd)
  :use-module (alterator ahttpd)

  :use-module (alterator ahttpd workflow)
  :use-module (alterator ahttpd translate)
  :use-module (alterator http html)
  :use-module (alterator http template)
  :export (make-html-response
           make-error-response
           make-alterator-response))

(define *html-dtd* "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">")

(define (make-html-response code content)
  (make-string-response code
			"text/html;charset=utf-8"
			(string-append *html-dtd* content)))


;; error response is text plain or we need to use html:quote
(define (make-error-response code content)
  (make-string-response code "text/plain;charset-utf-8" content))

;; alterator response
(define (scm->string scm)
  (with-output-to-string
    (lambda() (scm->out scm display))))

;;; workflow
(define (make-workflow-response framework-uri uri msg)
  (process-translate
    uri
    msg
    (process-module uri msg framework-uri)))

(define (make-alterator-response framework-uri uri request)
  (catch
    'html-redirect-error
    (lambda()
      (let* ((answer (make-workflow-response framework-uri uri request)))
	(make-html-response 200 (scm->string answer))))
    (lambda (key new-url . cookies)
      (apply make-redirect-response new-url cookies))))
