(define-module (alterator ahttpd translate)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-13)
  :use-module (alterator str)
  :use-module (alterator algo)
  :use-module (alterator ahttpd)
  :use-module (alterator gettext)
  :use-module (alterator http html)
  :use-module (alterator http template)
  :export (process-translate
           find-po-domain))

;; i18n

(define (find-po-domain scm)
  (call-with-current-continuation
    (lambda(return)
      (template scm
         (tag: "html"
            (lambda(options content)
               (return (cond-assq 'po-domain options))))))))

(define (po-domain scm url)
  (or (find-po-domain scm)
      (default-po-domain url)))

;; translation engine

(define (other-option? x)
  (not (eq? (car x) 'value)))

(define (translate-value hsh options domain def-domain)
  (let ((value (cond-assq 'value options)))
    (if value
      (acons 'value (translate hsh value domain def-domain)
	     (filter other-option? options))
      options)))

(define (translate-js hsh)
  (let ((_ (translator-cache-ref hsh "alterator-ahttpd")))
    (tag: "head"
	  (@ 'template-operation 'append-content)
	  (html: "script"
		 (format #f "var weekList = [ \"~A\", \"~A\", \"~A\", \"~A\" ,\"~A\",\"~A\",\"~A\" ];~%"
			 (_ "Mo")
			 (_ "Tu")
			 (_ "We")
			 (_ "Th")
			 (_ "Fr")
			 (_ "Sa")
			 (_ "Su"))
		 (format #f "var monthList=[ \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\", \"~A\" ];~%"
			 (_ "January")
			 (_ "February")
			 (_ "March")
			 (_ "April")
			 (_ "May")
			 (_ "June")
			 (_ "July")
			 (_ "August")
			 (_ "September")
			 (_ "October")
			 (_ "November")
			 (_ "December"))))))

;;translate template

(define (process-translate2 scm hsh default-domain)
      (template
	scm
	(translate-js hsh)
	(replace-tag: "span"
		      (lambda (options content)
			(let ((domain (cond-assq 'translate options)))
			  (if domain
			    `(span ,@options ,(translate hsh
							 (apply string-append (filter string? content))
							 domain
							 default-domain))
			    `(span ,@options ,(process-translate2 content hsh default-domain))))))
	(replace-tag: "input"
		      (@ 'type "button")
		      (lambda (options content)
			(let ((domain (cond-assq 'translate options "_")))
			  `(input ,@(translate-value hsh options domain default-domain) ,@content))))
	(replace-tag: "input"
		      (@ 'type "submit")
		      (lambda (options content)
			(let ((domain (cond-assq 'translate options "_")))
			  `(input ,@(translate-value hsh options domain default-domain) ,@content))))
	(replace-tag: "input"
		      (@ 'type "reset")
		      (lambda (options content)
			(let ((domain (cond-assq 'translate options "_")))
			  `(input ,@(translate-value hsh options domain default-domain) ,@content))))))

(define (process-translate url msg scm)
  (let* ((langlist (message-accept-language msg))
	 (default-domain (po-domain scm url))
	 (hsh (make-translator-cache (string-cut langlist #\;))))
    (process-translate2 scm hsh default-domain)))
