(define-module (alterator ahttpd workflow)
  :use-module (srfi srfi-13)
  :use-module (srfi srfi-2)
  :use-module (alterator str)
  :use-module (alterator algo)
  :use-module (alterator plist)
  :use-module (alterator ahttpd)
  :use-module (alterator http template)
  :use-module (alterator ui)

  :use-module (alterator woo)

  :export (process-module))

;;; new style template processing

(define (template-wf scm)
  (call-with-current-continuation
    (lambda(return)
      (template scm
		(tag: "html"
		      (lambda(options content)
			(return (cond-assq 'wf options "none"))))))))

(define (open-template url)
  (and-let* ((path (resolve-path url "html"))
	     ((string? path))
	     (scm (file->scm path))
	     (wf   (string-split (template-wf scm) #\?))
	     (wf-name (car wf))
	     (wf-args (parse-url-args (or (cond-cadr wf) ""))))
	    (cons* (cons 'scm scm)
	           (cons 'template wf-name)
		   (map (lambda(x) (cons (string->symbol (car x)) (cdr x)))
			wf-args))))

;;;
(define (process-workflow url msg template-args)
  (let* ((name (cond-assq 'template template-args "none"))
	 (proc (dynamic-require `(alterator workflow ,(string->symbol name)) 'workflow)))
    (if (procedure? proc)
      (proc url msg template-args)
      (woo-error "Unable to find workflow " name))))

(define (process-module uri msg . framework-uri)
  (let ((framework-uri (if (pair? framework-uri) (car framework-uri) uri)))
      (process-workflow uri
			msg
			(or (open-template framework-uri)
			    (woo-error "No template information provided for url " framework-uri)))))

