; Some common functions for creating alterator forms.
; This library is experimental now and is subject to changes without notification
;
; -- slazav@altlinux.org

(define-module (alterator card-index)
    :use-module (alterator woo)
    :use-module (alterator algo)
    :use-module (alterator ajax)
    :export (

      f-reset          ;; fill form using values from backend
      f-submit         ;; push all form values to the backend
      f-update-list    ;; update list from the backend
      f-get-ci-value   ;; smartly get card-index name
      f-update-ci-list ;; update card-index
    ))

;;;

(define (f-reset url . args)
  (catch/message (lambda ()
    (form-update-value-list
      (apply woo-read-first url 'language (form-value "language") args) ))))

(define (f-submit url . args)
  (catch/message (lambda ()
    (apply woo-write url 'language (form-value "language")
      (append (form-value-list) args) ))))

(define (f-update-list name url . args)
  (catch/message (lambda ()
    (form-update-enum name
      (apply woo-list url 'language (form-value "language") args) ))))

;;;

(define (mysplit str)
  (string-split (if (string? str) str "") #\;) )

;; get current name
(define (f-get-ci-value name . list)
  (cond-car (mysplit
    (or (form-value name)
        (if (pair? list) (woo-get-option (cond-car list) (string->symbol name))) ))))

;; update list, keep previous value or set the first one, return value
(define (f-update-ci-list name url . args)
  (catch/message ( lambda ()
    (let* ((d (apply woo-list url 'language (form-value "language") args))
           (v (apply f-get-ci-value name d)))
      (form-update-enum  name d)
      (form-update-value name v)
      ))))
