(define-module (alterator common)
	       :use-module (alterator str)
	       :use-module (srfi srfi-1)
	       :export (
			alterator-init-local
			alterator-init-global

			program-name))

(define (alterator-init-global)
  (or (getenv "ALTERATOR_DATADIR")
      (setenv "ALTERATOR_DATADIR" "/usr/share/alterator"))
  (or (getenv "ALTERATOR_LIBDIR")
      (setenv "ALTERATOR_LIBDIR" "/usr/lib/alterator"))
  (set! %load-path
        (fold cons
	      %load-path
	      (reverse (string-split (or (getenv "ALTERATOR_DATADIR") "") #\:)))))

(define (alterator-init-local)
  (alterator-init-global)
  (set! %load-path (cons "." %load-path))
  (setenv "ALTERATOR_DEBUG" "1")
  (setenv "ALTERATOR_DATADIR"
	  (string-append "." ":" (getenv "ALTERATOR_DATADIR")))
  (setenv "ALTERATOR_LIBDIR"
	  (string-append "." ":" (getenv "ALTERATOR_LIBDIR"))))

(define program-name (basename (car (command-line))))

