(define-module (alterator config)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-2)
  :use-module (srfi srfi-13)
  :use-module (ice-9 rdelim)
  :export (open-file-config
	   config-ref))

(define (not-comment? line)
  (not (or (string-null? line)
           (char=? (string-ref line 0) #\#))))

(define (open-file-config filename)
  (filter-map (lambda(line)
		(and-let* (((not-comment? line))
			   (tokens (string-tokenize line))
			   (name (car tokens))
			   (value (and (pair? (cdr tokens)) (cadr tokens))))
			  (cons name value)))
	      (with-input-from-file
		filename
		(lambda()
		  (unfold eof-object? values (lambda (x) (read-line)) (read-line))))))

(define (config-ref config key . default)
  (cond
    ((assoc key config) => cdr)
    (else (if (pair? default)
              (car default)
              (error (format #f "Parameter \"~A\" not found in config" key))))))
