(define-module (alterator container)
  :use-module (srfi srfi-11)
  :export (container-replace!
           container-check-range
	   safe-container-ref))

;generic algorithms for containers like vector and string

(define (get-container-ops obj)
  (cond ((string? obj) (values string-length string-ref string-set!))
        ((list? obj)   (values length list-ref list-set!))
        ((vector? obj) (values vector-length vector-ref vector-set!))))

(define (container-replace! cont rep-cont start)
  (let-values (((length elt-ref elt-set!) (get-container-ops cont)))
    (let ((rep-len (length rep-cont))
          (len (length cont)))
      (let loop ((start start)
                 (rep-start 0))
        (if (or (>= rep-start rep-len) (>= start len))
            start
            (begin (elt-set! cont
                             start
                             (elt-ref rep-cont rep-start))
                   (loop (+ start 1)
                         (+ rep-start 1))))))))


(define (container-check-range cont number)
  (let-values (((length elt-ref elt-set!) (get-container-ops cont)))
    (and (number? number)
         (< -1 number (length cont)))))


(define (safe-container-ref cont number)
  (let-values (((length elt-ref elt-set!) (get-container-ops cont)))
    (and (container-check-range cont number)
         (elt-ref cont number))))

