(define-module (alterator d)
    :use-module (vhttpd)
    :use-module (srfi srfi-1)
    :use-module (alterator algo)
    :use-module (alterator pipe)
    :use-module (alterator woo)
    :use-module (alterator exit-handler)
    :export (d-loop
             d-control
             d-query

             d-init-local
             d-init-global
             d-end

             d-wait
             d))

(define *d-socket* "/var/run/alteratord/.socket")
(define *d-user* "root")
(define *d-group* "_alteratord")
(define *d-control* "/etc/rc.d/init.d/alteratord")
(define *d-process* #f)

(define *null-port* (open-output-file "/dev/null"))

;; conversion between text and s-exp

(define (text->scm str)
  (catch
    #t
    (lambda()
      (with-input-from-string str read))
    (lambda args '())))

(define (scm->text scm)
  (catch
    #t
    (lambda()
      (with-output-to-string (lambda() (write scm))))
    (lambda args "")))

;; API

(define (d-loop proc)
  (let* ((server (make-unix-server *d-socket*))
	 (uid (passwd:uid (getpwnam *d-user*)))
	 (gid (group:gid (getgrnam *d-group*))))
    (chmod *d-socket* #o660)
    (chown *d-socket* uid gid)
    (server-loop server
                (lambda (code request)
		  (make-string-response
		    code
		    "text/plain"
		    (if (= code 200)
		      (scm->text (proc (text->scm (message-body request))))
		      "error"))))))

(define (d-control . args)
  (let ((pid (primitive-fork)))
    (cond
      ((zero? pid)
       (catch/ignore
	 #t
	 (lambda()
	   (dup2 (fileno *null-port*) 1)
	   (dup2 (fileno *null-port*) 2)
	   (apply execl *d-control* *d-control* args)))
       (primitive-exit 1))
      (else
	(waitpid pid)))))

(define (d-query cmd)
  (request-unix-server *d-socket*
		       (scm->text cmd)
		       (lambda(code response)
			 (if (= code 200)
			   (unpack-exception (text->scm (message-body response)))
			   (error "Unable to connect to alteratord service")))))

;;note: don't use control script, because init script pass all stderr to initlog

(define (d-wait)
  (or (= (request-unix-server *d-socket* "" (lambda(code response) code)) 200)
      (begin (usleep 5000)
	     (d-wait))))

(define (d-init-local)
  (d-control "stop")
  (set! *d-process* (create-process #f "/usr/sbin/alteratord" "-l"))
  (d-wait))

(define (d-init-global)
  (d-control "stop")
  (set! *d-process* (create-process #f "/usr/sbin/alteratord"))
  (d-wait))

(define (d-end)
  (and *d-process*
       (begin (stop-process 'terminate *d-process*)
	      (set! *d-process* #f))))

;;backward compatibility: woobus-module
(define (d)
  (lambda(cmds next)
    (next (append-map d-query cmds))))

;;; at-exit cleanup
(at-exit d-end)
