;; library over main form library to create enable/disable and show/hide visual effects in forms
(define-module (alterator effect)

  :use-module (srfi srfi-1)
  :use-module (alterator algo)
  :use-module (alterator ajax)

  :export (init-effect
           update-effect

           effect-enable
           effect-disable
           effect-show
           effect-hide))

;;; effects: common

(define (effect-tlist tlist)
  (delete-duplicates (or (form-session-ref tlist) '())))

(define (effect-add! slist tlist fieldname targetname targetvalue)
  (form-session-set! tlist (cons targetname (or (form-session-ref tlist) '())))
  (let* ((l (or (form-session-ref slist) '()))
	 (v (cond-assoc fieldname l '()))
	 (l (alist-delete fieldname l)))
    (form-session-set! slist (alist-set fieldname (cons (cons targetname targetvalue) v) l))))

(define (effect-need? rules)
  (any (lambda(x) (equal? (form-value (car x)) (cdr x)))
       rules))

(define (effect-check graph proc)
  (for-each (lambda(x) (proc (car x)
			     (effect-need? (cdr x))))
	    (or (form-session-ref graph) '())))

(define (effect-make tlist check)
  (for-each (lambda(name) (form-bind name "change" check))
	    (effect-tlist tlist))
  (check))


(define (effect-do-not func)
  (lambda (name need)
     (func name (not need))))

;;; effects: disable

(define (effect-disable fieldname targetname targetvalue)
  (effect-add! "effect-disable-slist"
	       "effect-disable-tlist"
	       fieldname
	       targetname
	       targetvalue))

(define (effect-disable-do name need)
  (form-update-activity name (not need)))

(define (effect-disable-check)
  (effect-check "effect-disable-slist"
                effect-disable-do))

;;; effects: enable

(define (effect-enable fieldname targetname targetvalue)
  (effect-add! "effect-enable-slist"
	       "effect-enable-tlist"
	       fieldname
	       targetname
	       targetvalue))

(define (effect-enable-check)
  (effect-check "effect-enable-slist"
                (effect-do-not effect-disable-do)))

;;; effects: show

(define (effect-show fieldname targetname targetvalue)
  (effect-add! "effect-show-slist"
	       "effect-show-tlist"
	       fieldname
	       targetname
	       targetvalue))

(define (effect-show-do name need)
  (form-update-visibility name need))

(define (effect-show-check)
  (effect-check "effect-show-slist"
                effect-show-do))

;;; effects: hide

(define (effect-hide fieldname targetname targetvalue)
  (effect-add! "effect-hide-slist"
	       "effect-hide-tlist"
	       fieldname
	       targetname
	       targetvalue))

(define (effect-hide-check)
  (effect-check "effect-hide-slist"
                (effect-do-not effect-show-do)))

;;; effects: common

(define (init-effect)
  (effect-make "effect-disable-tlist"
               effect-disable-check)

  (effect-make "effect-enable-tlist"
               effect-enable-check)

  (effect-make "effect-show-tlist"
               effect-show-check)

  (effect-make "effect-hide-tlist"
               effect-hide-check))

(define (update-effect)
  (effect-enable-check)
  (effect-disable-check)
  (effect-show-check)
  (effect-hide-check))
