(define-module (alterator exit-handler)
  :export (with-exit-handler
           at-exit))


(define *handlers* '())

(define (at-exit proc) (set! *handlers* (cons proc *handlers*)))

(define (run-at-exit)
  (for-each (lambda(x) (x)) *handlers*))

(define (with-exit-handler proc)
  (with-throw-handler
    #t
    (lambda()
      (proc)
      (run-at-exit))
    (lambda args
      (run-at-exit)
      (apply throw args))))

