(define-module (alterator gettext)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-13)
  :use-module (alterator algo)
  :use-module (alterator str)
  :export (dlgettext
           make-translator
           make-translator-cache
           translator-cache-ref
           translate
           default-po-domain))

(load-extension "libguile-gettext.so" "scm_init_gettext")

;;; translator

(define (domain-exists? domain locale)
  (read-access? (string-append "/usr/share/locale/" locale "/LC_MESSAGES/" domain ".mo")))

(define (short-locale x)
  (if (> (string-length x) 2)
    (string-take x 2)
    x))

(define (preffered-locale domain candidates)
 (any (lambda(l)
	(and (or (domain-exists? domain (short-locale l))
		 (domain-exists? domain l))
	     (string-append l ".UTF8")))
      candidates))

(define (make-translator domain candidates)
 (let ((l (preffered-locale domain candidates)))
  (if l
      (lambda(msgid) (dlgettext domain msgid l))
      values)))

;;; translator-cash

(define (make-translator-cache candidates)
  (cons (make-hash-table 10) candidates))

(define (translator-cache-ref hsh domain)
  (let ((tr (hash-ref (car hsh) domain)))
    (or tr
        (let ((tr (make-translator domain (cdr hsh))))
          (hash-set! (car hsh) domain tr)
          tr))))

(define (translate hsh str domain default-domain)
  (if (string-null? str)
    str
    (let* ((d (if (string=? domain "_") default-domain domain))
	   (tr (translator-cache-ref hsh d)))
      (tr str))))

(define (default-po-domain url)
  (let* ((url (string-trim-both url #\/))
	 (start (and (not (string-null? url)) (string-index url #\/ 0)))
	 (base (substring url 0 (or start (string-length url)))))
    (string-append "alterator-" base)))
