;; (snow homovector)
;; Copyright (C) 2006-2007 by Marc Feeley, All Rights Reserved.
;; License LGPLv2

(define-module (alterator homovector)
	       :use-module (srfi srfi-4)
	       :export (;;
			ISO-8859-1-substring->u8vector
			ISO-8859-1-string->u8vector
			subu8vector->ISO-8859-1-string
			u8vector->ISO-8859-1-string

			;;
			subu8vector
			subu8vector-move!
			
			;;
			u8vector-append
			apply-u8vector-append
			))

;;;

(define (ISO-8859-1-substring->u8vector str start end)
  (let* ((len (- end start))
	 (u8vect (make-u8vector len)))
    (let loop ((i 0))
      (if (< i len)
	(begin
	  (u8vector-set!
	    u8vect
	    i
	    (char->integer (string-ref str (+ start i))))
	  (loop (+ i 1)))
	u8vect))))

(define (ISO-8859-1-string->u8vector str)
  (ISO-8859-1-substring->u8vector
    str
    0
    (string-length str)))

(define (subu8vector->ISO-8859-1-string u8vect start end)
  (let* ((len (- end start))
	 (str (make-string len)))
    (let loop ((i 0))
      (if (< i len)
	(begin
	  (string-set!
	    str
	    i
	    (integer->char (u8vector-ref u8vect (+ start i))))
	  (loop (+ i 1)))
	str))))

(define (u8vector->ISO-8859-1-string u8vect)
  (subu8vector->ISO-8859-1-string
    u8vect
    0
    (u8vector-length u8vect)))

;;;

(define (subu8vector-move! src src-start src-end dst dst-start)
  (if (< src-start dst-start)
    (let loop1 ((i (- src-end 1))
		(j (- (+ dst-start (- src-end src-start)) 1)))
      (if (< i src-start)
	dst
	(begin
	  (u8vector-set! dst j (u8vector-ref src i))
	  (loop1 (- i 1)
		 (- j 1)))))
    (let loop2 ((i src-start)
		(j dst-start))
      (if (< i src-end)
	(begin
	  (u8vector-set! dst j (u8vector-ref src i))
	  (loop2 (+ i 1)
		 (+ j 1)))
	dst))))

(define (subu8vector u8vect start end)
  (subu8vector-move!
    u8vect
    start
    end
    (make-u8vector (max (- end start) 0))
    0))

;;;

(define (apply-u8vector-append lst)

  (define (append-rest-at i lst)
    (if (pair? lst)
      (let* ((src (car lst))
	     (len (u8vector-length src))
	     (dst (append-rest-at (+ i len) (cdr lst))))
	(subu8vector-move! src 0 len dst i)
	dst)
      (make-u8vector i)))

  (append-rest-at 0 lst))

(define (u8vector-append . lst)
  (apply-u8vector-append lst))

