;; Module for creating standard "login" and "logout" interfaces
;; Assumtions:
;; "login" - field with login name, this name may be fixed via login function parameter
;; "password" - field with login password
;; "locale" - field to change login language
;; Main functions:
;; login - create login interface, optional argument - commit callback, default value is a commit-login
;; commit-login - standard login commit callback, optional argument - login name (e.g. root), default-value (form-value "login")
;; logout -create logout interface

;; example 1: (define init login) ;; simplest case
;; example 2; (define (init) (login (lambda() (commit-login "root"))))

(define-module (alterator login)
    :use-module (alterator ahttpd) ;; uri-prefix?
    :use-module (alterator ajax)
    :use-module (alterator str) ;; string-cut
    :use-module (alterator woo)
    :use-module (alterator session)
    :export (
	     login
	     commit-login
	     logout))

;;; private

(define *life-time* (* 60 60 3))

(define (continue-path)
 (let ((path (form-value "continue")))
   (or (and (string? path)
            (not (string-null? path))
            (char=? (string-ref path 0) #\/)
            (not (uri-prefix? (ahttpd-session-ref 'ahttpd-uri) path))
            path)
        "/")))

(define (change-locale)
  (form-update-cookie "language" (form-value "locale"))
  (form-replace (ahttpd-session-ref 'ahttpd-uri) 'continue (or (form-value "continue") "/")))

;;; public interface

(define (commit-login . name)
  (let ((login (if (pair? name) (car name) (form-value "login"))))
    (catch/message
      (lambda()
	(woo-call "/login/authenticate"
		   'login login
		   'password (form-value "password")
		   'language (form-value "language"))
	(form-update-cookie "session" (make-session login *life-time*))
	(form-replace (continue-path))))))

(define (login . commit)
  (let ((commit (if (pair? commit) (car commit) commit-login)))
    (catch/message
      (lambda()
	(form-update-enum "locale" (woo-call "/login/list_locale"))
	(form-update-value "locale" (car (string-cut (form-value "language") #\;)))
	(form-bind "locale" "change" change-locale)
	(form-bind "commit" "click" commit)
	(form-bind "password" "enter" commit)))))

(define (logout)
  (session-delete (form-cookie "session"))
  (form-update-cookie "session" "")
  (form-replace "/"))
