;description: per dialog global variables
;globals is a list of frames, each frame is alist

(define-module (alterator lookout globals)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator plist)
	       :use-module (alterator context)
	       :export (global
			set-global!

			make-globals
			with-globals
			extend-globals
			reset-globals!))

;description: per dialog global variables
;globals is a list of frames, each frame is alist

(define (prepare-globals lst)
  (plist->alist lst))

(define (make-globals lst)
  (list (prepare-globals lst)))

(define (extend-globals lst)
  (define (cond-append a b) (if b (append a b) a))
  (cond-append (make-globals lst) (from-context 'globals)))

(define (reset-globals! lst)
 (let ((current-globals (from-context 'globals)))
    (and (pair? current-globals)
	 (set-car! current-globals (prepare-globals lst)))))

(define (global name)
  (define (frame-assq frame)
    (cond-cdr (assq name frame)))
  (let ((current-globals (from-context 'globals)))
    (and (pair? current-globals)
         (any frame-assq current-globals))))

(define (set-global! name value)
  (let ((current-globals (from-context 'globals)))
    (and current-globals
	 (set-car! current-globals (alist-set name value (car current-globals))))))

(define-macro (with-globals <globals> <instruction> . <instructions>)
     `(with-changed-context 'globals ,<globals> ,<instruction> . ,<instructions>))


