(define-module (alterator lookout goto)
  :use-module (ice-9 rdelim)

  :use-module (srfi srfi-2)

  :use-module (alterator algo)
  :use-module (alterator str)
  :use-module (alterator object)
  :use-module (alterator context)
  :use-module (alterator ajax)

  :use-module (alterator presentation common)
  :use-module (alterator presentation container)

  :use-module (alterator session common)

  :use-module (alterator lookout globals)
  :use-module (alterator lookout evaluation)

  :export (document:replace
           document:replace-in-widget
           clean-widget))

(define (clean-widget widget proc . url)
  (define-operation delete-subwidgets #f)
  (define-operation clear-events #f)
  (define-operation recreate-subwidgets)
  (define-operation recreate-attrs)
  (define-operation message-on)
  (define-operation message-off)
  (define-operation call)
  (define-operation no-messages?)

  (simple-notify widget 'action "clean")
  (delete-subwidgets widget)
  (clear-events widget)

  (without-notifications (proc));;major widget modifications here

  (recreate-attrs widget)
  (recreate-subwidgets widget)

  (or (no-messages? (fluid-ref generic-session))
      (begin (call widget (make-attribute 'loaded))
             (and (pair? url) (form-callback "on-load" (->string (car url)))))))

(define (replace-globals new)
  (let ((old-root (global 'document:root))
        (old-loop (global 'document:loop))
        (old-popup (global 'document:popup)))
    (reset-globals! new)
    (set-global! 'document:root old-root)
    (set-global! 'document:loop old-loop)
    (set-global! 'document:popup old-popup)))

(define (document:replace-in-widget widget url . url-args)
  (define-operation get-context)
  (define-operation call)

  ;;work with widget's context and it's globals
  (with-context (get-context widget)
		(clean-widget widget
			      (thunk
				(replace-globals url-args)
				(set-global! 'document:url (->string url))
				(widget (document:eval url)))
				url)))

(define (document:replace url . url-args)
  (apply document:replace-in-widget
         (global 'document:root) url url-args))
