(define-module (alterator lookout messagebox)

  :use-module (srfi srfi-1)
  :use-module (alterator algo)
  :use-module (alterator gettext)
  :use-module (alterator object)

  :use-module (alterator presentation container)
  :use-module (alterator lookout globals)
  :use-module (alterator session common)

  :export (document:messagebox
           document:popup-type
           document:popup-information
           document:popup-warning
           document:popup-critical
           document:popup-question))

(define (document:messagebox . args)
  (define-operation pause)
  (apply simple-notify (global 'document:root) 'action "messagebox" args)
  (pause (fluid-ref generic-session)))

(define (default-button args)
  (if (pair? args)
    (car args)
    'no-button))

(define (document:popup-type type title message . buttons)
  (document:messagebox
    'type type
    'title title
    'message message
    'buttons buttons
    'default-button (default-button buttons)))

(define (document:popup-information message . buttons)
  (let ((_ (make-translator "alterator-lookout" (session-language))))
    (apply document:popup-type "information" (_ "Information") message buttons)))

(define (document:popup-warning message . buttons)
  (let ((_ (make-translator "alterator-lookout" (session-language))))
    (apply document:popup-type "warning" (_ "Warning") message buttons)))

(define (document:popup-critical message . buttons)
  (let ((_ (make-translator "alterator-lookout" (session-language))))
    (apply document:popup-type "critical" (_ "Critical") message buttons)))

(define (document:popup-question message . buttons)
  (let ((_ (make-translator "alterator-lookout" (session-language))))
    (apply document:popup-type "question" (_ "Question") message buttons)))

