(define-module (alterator lookout presentation)
  :use-module (alterator algo)
  :use-module (alterator str)
  :use-module (alterator object)
  :use-module (alterator context)

  :use-module (alterator presentation container)

  :use-module (alterator lookout globals)
  :use-module (alterator lookout widgets)
  :use-module (alterator lookout evaluation)

  :export (make-container-presentation
           with-container-presentations
	   prepare-container-presentation))

;;this helper allow to use to implement recursive definitions, like document:root
(define (prepare-container-presentation container url)
  (define-operation reset-context)

  (let* ((url-name (or (cond-car url) url))
	 (url-args (or (cond-cdr url) '())))
    (with-globals (extend-globals '())
		  (reset-globals! url-args)
		  (set-global! 'document:root container)
		  (and url-name (set-global! 'document:url (->string url-name)))
		  (reset-context container)
		  (and url-name (container (document:eval url-name)))
		  container)))

;;create combound widgets
(define (make-container-presentation url . default-args)
  (let ((default-args-len (length default-args)))
    (lambda args
      (let ((container (prepare-container-presentation (make-container) url)))
	(container (join-args args default-args default-args-len))
	container))))

(define-macro (with-container-presentations <presentations> <instruction> . <instructions>)
  `(let ,(map (lambda(item) `(,(car item) (make-container-presentation ,@(cdr item)))) <presentations>)
     ,<instruction> . ,<instructions>))
