(define-module (alterator lookout root)
  :use-module (alterator algo)
  :use-module (alterator object)

  :use-module (alterator presentation common)
  :use-module (alterator presentation container)
  :use-module (alterator session common)
  :use-module (alterator session loop)

  :use-module (alterator lookout presentation)
  :use-module (alterator lookout globals)

  :export ( document:subdocument
            document:popup ))

(define (document:subdocument . url)
    (prepare-container-presentation (make-container)
                                    (if (pair? url) url #f)))

(define (start-loop loop popup)
  (define-operation need-loop)
  (define-operation start)
  (define-operation delete)

  (let ((need-start (need-loop loop)))
    (and need-start (simple-notify popup 'action "start"))
    (begin-1 (start loop popup)
             (and need-start (simple-notify popup 'action "stop"))
             (simple-notify popup 'action "close")
             (delete popup))))

;;FIXME: sub-type attribute is unused by modern browsers
(define (document:popup . url)
  (define-operation recreate)
  (define-operation call)

  (let* ((loop (make-loop))
         (popup (make-container "root")))
    (without-notifications
     (prepare-container-presentation popup
                                     (append url
                                             (list 'document:loop loop
                                                   'document:popup popup)))
     (popup (make-init-attribute 'parent 0 (or (global 'document:popup) ""))))

    ;;now made notifications and start loop
    (recreate popup)
    (call popup (make-attribute 'loaded))
    (start-loop loop popup)))

(define (make-pseudo-loop window proc)
  (define-operation delete)

  (object #f
          ((stop . args)
	   (simple-notify window 'action "close")
           (delete window)
           (proc))))
