(define-module (alterator lookout tree)
    :use-module (srfi srfi-1)
    :use-module (srfi srfi-13)
    :use-module (alterator str)
    :use-module (alterator algo)
    :export (make-coordinates tree-map tree-path tree-leaf?))

(define (code->string code)
  (list (string-join (map ->string (reverse code)) ",")))

(define (make-coordinates lst)
  (let loop ((code (list 0))
             (lst lst)
             (result '()))
    (cond
     ((null? lst) result)
     ((list? (car lst))
        (loop code
              (cdr lst)
              (loop (cons 0 (cons (- (car code) 1) (cdr code)))
                    (car lst) result)))
     (else (loop (cons (+ 1 (car code)) (cdr code))
                 (cdr lst)
                 (append result
                         (code->string code)))))))

(define (tree-map thunk lst)
  (let loop ((lst lst)
             (result '()))
    (cond
     ((null? lst) result)
     ((list? (car lst)) (loop (cdr lst)
                              (append1 result (loop (car lst) '() ))))
     (else (loop (cdr lst) (append1 result (thunk (car lst))))))))

(define (node-ref lst num)
  (cond
   ((list? (car lst)) (node-ref (cdr lst) num))
   ((zero? num) lst)
   (else (node-ref (cdr lst) (- num 1)))))

(define (tree-path tree num)
  (let loop ((tree tree)
             (num num)
             (result '()))
    (if (pair? num)
        (let ((node (node-ref tree (car num))))
              (loop (cond-cadr node) (cdr num) (append1 result (car node))))
        result)))

(define (tree-leaf? tree num)
    (if (pair? num)
        (let ((node (node-ref tree (car num))))
              (tree-leaf? (cond-cadr node) (cdr num)))
        (not (list? tree))))
