(define-module (alterator lookout widgets)
  :use-module (srfi srfi-1)

  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator presentation container)
  :use-module (alterator lookout attributes)
  :export (join-args
           make-widget)

  :export (radio button label edit groupbox textbox
           tab-page checkbox box spinbox gridbox tabbox
           listbox checklistbox radiolistbox combobox progressbar
           slider tree menubar spacer separator dateedit
           timeedit splitbox checktree )

  ;;; backward compatibility
  :export (checklist radiolist))


(define (not-default-args args)
  (or (null? args)
      (memq (instance-of (cond-car args))
	    '(<attribute> <empty-attribute>))))

(define (join-args args default-args default-args-len)
  (let* ((len (if (not-default-args args) 0 default-args-len)))
    (append (map (lambda(x y) (x y)) default-args (take args len))
	    (list-tail args len))))

;;create simple widgets
(define (make-widget type . default-args)
  (let ((default-args-len (length default-args)))
    (lambda args
      (let ((container (make-container type)))
	(container (join-args args default-args default-args-len))
	container))))

(define-macro (with-widgets <presentations> <instruction> . <instructions>)
  `(let ,(map (lambda(item) `(,(car item) (make-widget ,@(cdr item)))) <presentations>)
     ,<instruction> . ,<instructions>))

(define-macro (define-widget <name> . <args>)
  `(define ,<name> (make-widget ,(symbol->string <name>) ,@<args>)))

(define-widget button text)
(define-widget radio text)
(define-widget edit text)
(define-widget textbox text)
(define-widget spinbox)
(define-widget slider)
(define-widget dateedit)
(define-widget timeedit)

(define-widget label text)
(define-widget groupbox title)
(define-widget tab-page text)
(define-widget checkbox text)
(define-widget box)
(define-widget gridbox)
(define-widget tabbox)
(define-widget listbox)
(define-widget checklistbox)
(define-widget radiolistbox)
(define-widget combobox)
(define-widget progressbar)
(define-widget tree)
(define-widget menubar)
(define-widget spacer)
(define-widget separator)
(define-widget splitbox)
(define-widget checktree)

(define checklist checklistbox) ;;; backward compatibility
(define radiolist radiolistbox) ;;; backward compatibility
