;; library over menu backend with caching feature
(define-module (alterator menu)
    :use-module (alterator woo)
    :export (;; lists
	     menu-reset-item
	     menu-list-item
	     menu-list-group
	     ;; item
	     menu-item-ref
	     menu-item-expert?
	     menu-item-html-ui?
	     menu-item-qt-ui?
	     ;; group
	     menu-group-ref))

(define *item-cache* (make-hash-table 20))
(define *group-cache* (make-hash-table 20))
(define *item-expert-list* #f)

(define (menu-reset-item)
  (set! *item-cache* (make-hash-table 20)))

(define (menu-list-item . language)
  (let ((language (if (pair? language) (car language) "en_US")))
    (or (hash-ref *item-cache* language #f)
	(let ((item-list (woo-list "/menu/avail_modules" 'language language 'expert_mode #t 'ui "all")))
	  (hash-set! *item-cache* language item-list)
	  item-list))))

(define (menu-list-expert-item)
  (or *item-expert-list*
      (let ((expert-list (map (lambda(x) (woo-get-option x 'name)) (woo-list "/menu/expert_modules"))))
	(set! *item-expert-list* expert-list)
	expert-list)))

(define (menu-item-ref item key . default)
  (apply woo-get-option item key default))

(define (menu-item-expert? item)
  (member (menu-item-ref item 'desktopfile) (menu-list-expert-item)))

(define (menu-item-html-ui? item)
  (member (menu-item-ref item 'ui) '("html" "all")))

(define (menu-item-qt-ui? item)
  (member (menu-item-ref item 'ui) '("qt" "all")))

(define (menu-list-group . language)
  (let ((language (if (pair? language) (car language) "en_US")))
    (or (hash-ref *group-cache* language #f)
	(let ((group-list (woo-list "/menu/avail_sections" 'language language)))
	  (hash-set! *group-cache* language group-list)
	  group-list))))

(define (menu-group-ref item key . default)
  (apply woo-get-option item key default))
