(define-module (alterator plist)
  :use-module (srfi srfi-1)
  :export (
           ;;public
	   plistq
	   cond-plistq

           ;;for internal purposes
           plist?
           alist->plist
           plist->alist
	   plist-any
	   plist-map
	   plist-filter
	   plist-remove
	   plist-fold
	   plist-for-each))

(define (plist? lst)
  (and (list? lst) (even? (length lst))))

(define (plist-for-each proc lst)
  (let loop ((lst lst))
    (and (pair? lst) (pair? (cdr lst))
         (begin (proc (car lst) (cadr lst))
                (loop (cddr lst))))))

(define (plist-any pred lst)
  (let loop ((lst lst))
    (and (pair? lst) (pair? (cdr lst))
         (or (pred (car lst) (cadr lst))
             (loop (cddr lst))))))

(define (plistq key lst)
  (plist-any (lambda(x y)
                  (and (eq? x key)
                       (cons x y)))
	      lst))

(define (plist-map func plist)
  (unfold null?
          (lambda(x) (func (car x) (cadr x)))
          cddr
          plist))

(define (plist-fold func result plist)
  (let loop ((plist plist)
             (result result))
    (if (null? plist)
        result
        (loop (cddr plist) (func (car plist) (cadr plist) result)))))

(define (plist-remove proc plist)
  (reverse
   (let loop ((plist plist)
              (result '()))
     (cond
      ((null? plist)
       result)
      ((proc (car plist) (cadr plist))
       (loop (cddr plist) result))
      (else
       (loop (cddr plist)
             (cons* (cadr plist) (car plist) result)))))))

(define (plist-filter proc plist)
  (plist-remove (lambda(x y) (not (proc x y))) plist))

(define (plist->alist plist)
  (plist-map cons plist))

(define (alist->plist alist)
  (fold (lambda (item result)
            (cons* (car item) (cdr item) result))
        '()
        alist))

(define (cond-plistq name plist . default)
  (cond
   ((plistq name plist) => cdr)
   (else (if (pair? default) (car default) #f))))
