(define-module (alterator presentation args)
	       :use-module (alterator object)
	       :use-module (alterator presentation common)
	       :use-module (alterator presentation events)
               :export (parse-args))

(define (parse-args container arglist)
  (define-operation get)
  (define-operation set)
  (define-operation proxy-set)
  (define-operation insert)
  (define-operation run-callback)
  (define-operation list-subwidgets)
  
  (let loop ((arglist arglist))
    (or (null? arglist)
        (let ((arg (car arglist)))
          (case (instance-of arg)
            ((<number>)
             (let* ((children (list-subwidgets container)))
               (and (< arg (length children))
                    (let ((child (list-ref children arg)))
                      (if (pair? (cdr arglist))
                          (parse-args child (cdr arglist))
                          child)))))
            ((<proxy-holder>)
             (proxy-set container arg)
             (loop (cdr arglist)))
            ((<container>)
             (arg (make-init-attribute 'parent 0 container))
             (insert container arg)
             (loop (cdr arglist)))
            ((<pair>)
             (parse-args container arg)
             (loop (cdr arglist)))
            ((<attribute>)
             (set container arg)
             (loop (cdr arglist)))
            ((<empty-attribute>)
             (if (pair? (cdr arglist))
                 (loop (cons (arg (cadr arglist)) (cddr arglist)))
                 (let ((result (get container arg)))
                   (if (callback? result)
                       (run-callback container result)
                       result))))
            (else
             (loop (cdr arglist))))))))
