(define-module (alterator presentation events)
  :use-module (srfi srfi-1)
  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator context)
  :export (make-callback
           when
	   callback?))

;support for events in lookout interface descriptions

;;callback contructor
(define-macro (make-callback <action> . <actions>)
  `(object
    (lambda() ,<action> . ,<actions>)
    ((callback? self) #t)))

;;helper to create more declarative callback descriptions
(define-macro (when <event-name> <action> . <actions>)
  `(,<event-name> (make-callback  ,<action> . ,<actions>)))

(define-operation callback? #f)

