(define-module (alterator security wrap)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-11)
  :use-module (alterator algo)
  :export (toplevel-begin
           real-toplevel-begin
           
           document->toplevel-begin
           backend->toplevel-begin))

(define (definition? x)
  (and (list? x)
       (> (length x) 2)
       (eq? (car x) 'define)))

(define (use-module? item)
  (and (pair? item)
       (or (eq? (car item) 'dynamic-call)
           (eq? (car item) 'load-extention)
           (eq? (car item) 'use-modules))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (transform-definition x)
  (let ((name (cadr x)))
    (if (pair? name)
        `(define ,(car name) (lambda ,(cdr name) ,@(cddr x)))
        x)))

(define (prepare-definitions instructions)
  (fold (lambda(instr result)
          (let* ((first (car result))
                 (second (cdr result))
                 (is-definition (definition? instr))
                 (instr (if is-definition (transform-definition instr) instr)))
            (cons
             (if is-definition
                 (append1 first (cadr instr))
                 first)
             (append1 second instr))))
        (cons '() '())
        instructions))
  
(define-macro (real-toplevel-begin <setter> . <instructions>)
  (let* ((result (prepare-definitions <instructions>))
         (defs (car result))
         (insts (cdr result)))
    `(let ,(map (lambda(x) (list x #f)) defs)
       ,@(let ((convert (map (lambda(x) (if (definition? x) `(,<setter> ,@(cdr x)) x)) insts)))
           (if (eq? (car insts) 'list) (list convert) convert)))))


(define-macro (toplevel-begin-creator)
  (define saved-set! set!)
    `(define-macro (toplevel-begin . <instructions>)
         `(real-toplevel-begin ,,saved-set! . ,<instructions>)))

(toplevel-begin-creator)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;envelop several definitions with list instruction
(define (->list lst)
  (if (> (length lst) 1) `(list ,@lst) lst))

;convert internal definitions to letrec*
(define (document->toplevel-begin . lst)
  `(toplevel-begin ,@(->list lst)))

(define (backend->toplevel-begin . lst)
  (let-values (((uses other) (partition use-module? lst)))
    `(begin ,@uses
            (toplevel-begin ,@other))))
