(define-module (alterator session state)
  :use-module (alterator algo)
  :use-module (alterator object)
  :export (make-session-state))

(define (make-session-state)
  (let ((return-continuation #f)
        (resume-continuation #f))
        (object
         #f
         ;;control passing throw continuations
         ((start self proc) ;init thread computation, save first pause point
          (call-with-current-continuation
           (lambda (return)
             (set! return-continuation return)
             (proc))))
         ((resume self msg) ; resume thread computation
          (call-with-current-continuation
           (lambda (return)
             (set! return-continuation return)
             (resume-continuation msg))))
         ((sleep self proc) ;stop thread until next message arrived
          (call-with-current-continuation
           (lambda (restore)
             ;;skip first resume  - this was from start
	     (let ((previous-resume-continuation resume-continuation))
               (set! resume-continuation restore)
               (return-continuation (and previous-resume-continuation (proc))))))))))
