(define-module (alterator session widgets)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator object)

	       :export (make-widgets-glue))

(use-modules (alterator algo)
             (alterator object))

;reverse search
(define (cond-rassq key alist . default)
  (define (valid-value? key)
    (lambda(x) (eq? key (cdr x))))
  (cond
   ((find (valid-value? key) alist) => car)
   (else (if (pair? default) (car default) #f))))

(define (make-widget-counter)
  (let ((counter 0))
    (thunk
      (begin-1
	(string->symbol (string-append "w" (number->string counter)))
	(set! counter (+ counter 1))))))

(define (make-widgets-glue)
  (define-operation append-message-for-id)
  (define-operation create-id)
  (define-operation un-id)
  
  (let* ((widgets '()) ;;alist: widget -> id
         (messages (list #f)) ;;current messages to real interface
         (counter (make-widget-counter))
         (no-messages 0))
    (object
     #f
     ((no-messages? self) (> no-messages 0))
     ((message-on self) (set! no-messages (- no-messages 1)))
     ((message-off self)(set! no-messages (+ no-messages 1)))
     
     ((un-id self w) ;;replace widgets with their ids
      (cond-assq w widgets w))
     ((append-message-for-id self id args)
      (append! messages (list (cons "command"
                                    (map (lambda(x) (un-id self x))
                                         (cons* 'widget-id id args))))))
     ((read-messages self)
      (begin-1 (cdr messages)
               (set! messages (list #f))))
     ((create-id self w)
      (let ((id (counter)))
        (set! widgets (acons w id widgets))
        id))
     ((append-message self w . args)
      (and (zero? no-messages)
           (append-message-for-id self
                                  (or (cond-assq w widgets) (create-id self w))
                                  args)))
     ((take-widget self widget)
      (set! widgets (alist-delete widget widgets)))
     ((get-widget self id)
      (cond-rassq (sure-symbol id) widgets)))))
