(define-module (alterator session xml)
  :use-module (alterator woo)
  :use-module (alterator str)
  :use-module (alterator plist)
  :use-module (alterator algo)
  :export (command->xml
           xml-string-quote
           auth->xml))

(define (xml-string-quote str)
  (string-quote (lambda (ch)
                  (case ch
                    ((#\&) "&amp;")
                    ((#\') "&apos;")
                    ((#\") "&quot;")
                    ((#\<) "&lt;")
                    ((#\>) "&gt;")
                    (else (string ch))))
                str))

(define (command->xml cmd)
  (string-append
   (apply string-append
          (format #f " <~A xml:space=\"preserve\"" (xml-string-quote (car cmd)))
          (delq #f
                (plist-map
                 (lambda (name value)
                   (and (not (eq? name 'value))
                       (format #f " ~A=\"~A\""
                               name (xml-string-quote (sure-string value)))))
                 (cdr cmd))))
   ">"
   (xml-string-quote (sure-string (woo-get-option cmd 'value)))
   (format #f "</~A>" (xml-string-quote (car cmd)))
   (string #\newline)
   ))

(define (auth->xml cmd)
  (let ((user (woo-get-option cmd 'user #f))
        (session-id (woo-get-option cmd 'session-id #f))
        (content (woo-get-option cmd 'content #f)))
    (string-append
     (apply
      string-append
      (apply
       string-append
       "<auth-answer"
       (delq #f
             (list
              (and user (format #f " user=\"~A\"" (xml-string-quote user)))
              (and session-id (format #f " session-id=\"~A\"" (xml-string-quote session-id))))))
      ">"
      (string #\newline)
      (map command->xml content))
     "</auth-answer>"
     (string #\newline))))
