(define-module (alterator telegraph)
	       :use-module (alterator algo)
	       :use-module (alterator exit-handler)
	       :export (telegraph telegraph-start))

(define *modules* #f)

(define (telegraph . modules)
  (set! *modules* modules))

(define (telegraph-start)
  (with-exit-handler
    (thunk (or (null? *modules*)
               (telegraph-run '() *modules*)))))

(define (telegraph-run cmd modules)
    (if (null? modules)
      cmd
      ((car modules)
       cmd
       (lambda(cmd) (telegraph-run cmd (cdr modules))))))
