(define-module (alterator transport pipe-channel)
  :use-module (alterator pipe)
  :use-module (alterator algo)
  :use-module (alterator session xml)
  :export (pipe-in))

(define (process-incoming next p)
  (let* ((read-port (process-read-port p))
	 (cmd (read read-port)))
    (or (eof-object? cmd)
	(let ((ans (car (next (list cmd)))))
	  (eat-rest read-port)
	  (with-ignored-sigpipe
	    (thunk
	      (and (pair? ans)
		   (let ((write-port (process-write-port p)))
		     (display (auth->xml ans) write-port) ))))
	  (process-incoming next p)))))

(define (pipe-in command . args)
  (let ((p (apply create-process #t command args)))
    (lambda (cmds next)
      (process-incoming next p))))
