(define-module (alterator type domain-suffix-list)
  :use-module (alterator woo)
  :export (domain-suffix-list-regex type))

(define *domain-suffix-list-regex-str* "^\\.[a-z0-9-]+(\\.[a-z0-9-]+)*([ ]+\\.[a-z0-9-]+(\\.[a-z0-9-]+)*)*$")

(define domain-suffix-list-regex (make-regexp
                             *domain-suffix-list-regex-str*
                             regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec domain-suffix-list-regex v))
      (type-error (_ "a space separated list of domain suffixes each starting with a dot"))))
