(define-module (alterator type domain-suffix)
  :use-module (alterator woo)
  :export (domain-suffix-regex type))

(define *domain-suffix-regex-str* "^\\.[a-z0-9-]+(\\.[a-z0-9-]+)*$")

(define domain-suffix-regex (make-regexp
                             *domain-suffix-regex-str*
                             regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec domain-suffix-regex v))
      (type-error (_ "a domain suffix starting with a dot"))))
