(define-module (alterator ui)
	       :use-module (srfi srfi-1)
	       :use-module (alterator str)
	       :export (resolve-path))

(define *data-dir* (delay (string-split (or (getenv "ALTERATOR_DATADIR") "") #\:)))

(define (test-path path)
  (catch
    'system-error
    (lambda()
      (and (eq? (stat:type (stat path)) 'regular) 
	   (access? path R_OK)
	   path))
    (lambda args #f)))

(define (resolve-path url extension)
  (and (not (string-contains url "..")) 
       (any (lambda (data-dir)
	      (any (lambda (ui-dir)
		     (let ((prefix (string-append data-dir "/" ui-dir "/" url)))
		       (or (test-path (string-append prefix "/index." extension))
			   (test-path (string-append prefix "." extension)))))
		   '("ui" "templates")))
	    (force *data-dir*))))


