(define-module (alterator workflow acc)
    :use-module (srfi srfi-1)
    :use-module (srfi srfi-13)

    :use-module (alterator ahttpd)

    :use-module (alterator algo)
    :use-module (alterator woo)
    :use-module (alterator menu)

    :use-module (alterator http template)
    :use-module (alterator http html)

    :use-module (alterator ahttpd translate)
    :use-module (alterator ahttpd workflow)
  :export (workflow))

(define (scm-content scm name)
 (call-with-current-continuation
   (lambda(return)
    (template
      scm (tag: name (lambda (options content) (return content))))
    '())))

(define (acl-tag url desktopfile)
  (replace-tag: "div"
		(@ 'id "acl")
		(lambda (options content)
		  `(div ,@options
			,(@ 'style (format #f "visibility:~A;"
					   (if (member url '("/" "/ahttpd/acl")) "hidden" "visible")))
			,(html: "a"
				(@ 'href (format #f "/ahttpd/acl?desktopfile=~A" (encode-url-component desktopfile)))
				content)))))


(define (main-tag scm)
  (and (pair? scm)
    (tag: "div" (@ 'id "main") (scm-content scm "body"))))

(define (title? x)
  (and (pair? x) (eq? (car x) 'title)))

(define (head-tag scm title)
  (and (pair? scm)
    (replace-tag: "head"
		  (lambda(options content)
		    (list 'head
			  (remove title? content)
			  (remove title? (scm-content scm "head"))
			  (html: "title" title))))))

(define (title-tag title)
    (tag: "span" (@ 'id "title") title))

(define (apply-po-domain scm po-domain)
  (if (string? po-domain)
    (template scm
	      (replace-tag: "html" (lambda (options content)
				     `(html ,@options ,@content
					    ,(@ 'po-domain po-domain)))))
    scm))

;;; menu

(define (current-module? item url)
  (uri-prefix? (menu-item-ref item 'uri) url))

(define (find-module url module-data)
  (find (lambda(x) (current-module? x url))
        module-data))

(define (filter-module category module-data)
  (filter (lambda(x) (string=? category (menu-item-ref x 'category)))
        module-data))

(define (html:section group-name group-title items)
  (html: "div"
	 (@ 'class "menu-group ui-corner-all")
	 (html: "div"
		(@ 'class "menu-group-name ui-corner-all")
		(@ 'title group-title)
		group-name)
	 items))

(define (html:module item url)
  (html: "div"
	 (@ 'class (if (current-module? item url) "menu-item-selected" "menu-item-normal"))
	 (html: "a" (@ 'href (menu-item-ref item 'uri))
                    (menu-item-ref item 'name))))

(define (menu-tag url sections-data module-data)
  (tag: "div" (@ 'id "menu")
	(filter-map (lambda(section)
		      (let ((modules (filter-module (menu-group-ref section 'category) module-data)))
			(and (pair? modules)
			     (html:section
			       (menu-group-ref section 'name)
			       (menu-group-ref section 'comment)
			       (map (lambda(item) (html:module item url))
			            modules)))))
		     sections-data)))

(define (list-item language not-expert-user)
  (remove (lambda(item)
	    (or (not (menu-item-html-ui? item))
		(and not-expert-user (menu-item-expert? item))))
	  (menu-list-item language)))

(define (middle-tag sections-data module-data)
  (html: "table"
	 (@ 'class "main-table")
	 (@ 'style "margin:10px")
	 (filter-map
	   (lambda(x)
	     (let ((modules (filter-module (menu-group-ref x 'category) module-data)))
	       (and (pair? modules)
		    (html: "tr"
			   (html: "td"
				  (@ 'style "padding-bottom:20px")
				  (html: "img"
					 (@ 'src (string-append "/design/images/" (menu-item-ref x 'icon) ".png"))))
			   (html: "td"
				  (@ 'style "padding-bottom:20px;padding-left: 10px")
				  (html: "h2"
					 (@ 'style "margin: 0px") (menu-item-ref x 'name))
				  (html: "div"
					 (@ 'style "padding-top:5px;padding-bottom:5px")
					 (menu-item-ref x 'comment))
				  (html: "div"
					 (map (lambda(y)
						(html: "a" (@ 'href (menu-item-ref y 'uri))
						       (@ 'style "padding-right:10px")
						       (menu-item-ref y 'name)))
					      modules)))))))
	   sections-data)))

;;; main
(define (workflow url msg template-args)
  (let* ((scm2 (or (string=? url "/" ) (process-module url msg)))
	 (scm (cond-assq 'scm template-args))
	 (po-domain (and (pair? scm2) (find-po-domain scm2)))
	 (language (message-accept-language msg))
	 (expert-mode (message-expert-mode msg))

	 ;;new menu
	 (sections-data (menu-list-group language))
	 (module-data (list-item language (string=? expert-mode "0")))
	 (current-module (find-module url module-data))
	 (current-module-title (menu-item-ref current-module 'name))
	 (current-module-desktopfile (menu-item-ref current-module 'desktopfile)))

    (apply-po-domain
      (if (string=? (message-header msg "user-agent") "ALTLinux/AMC")
	;; without side menu
	(template
	  scm
	  (head-tag scm2 current-module-title)
	  (replace-tag: "div"
			(@ 'id "middle")
			(html: "div"
			       (@ 'id "main")
			       (@ 'class "box ui-corner-all")
			       (if (string=? url "/")
				 (middle-tag sections-data module-data)
				 (scm-content scm2 "body")))))
	;; with side menu
	(template scm
		  (acl-tag url current-module-desktopfile)
		  (head-tag scm2 current-module-title)
		  (title-tag current-module-title)
		  (menu-tag url sections-data module-data)
		  (main-tag scm2)))
      po-domain)))

