(define-module (alterator workflow chainmail)
    :use-module (srfi srfi-1)
    :use-module (srfi srfi-13)

    :use-module (alterator ahttpd)

    :use-module (alterator algo)
    :use-module (alterator woo)
    :use-module (alterator menu)

    :use-module (alterator http template)
    :use-module (alterator http html)

    :use-module (alterator ahttpd translate)
    :use-module (alterator ahttpd html)
    :use-module (alterator ahttpd workflow)
  :export (workflow))

(define (scm-content scm name)
 (call-with-current-continuation
   (lambda(return)
    (template
      scm (tag: name (lambda (options content) (return content))))
    '())))

(define (main-tag scm)
  (and (pair? scm)
    (tag: "div" (@ 'id "main") (scm-content scm "body"))))

(define (title? x)
  (and (pair? x) (eq? (car x) 'title)))

(define (head-tag scm title)
  (and (pair? scm)
    (replace-tag: "head"
		  (lambda(options content)
		    (list 'head
			  (remove title? content)
			  (remove title? (scm-content scm "head"))
			  (html: "title" title))))))

(define (title-tag title)
    (tag: "span" (@ 'id "title") title))

(define (apply-po-domain scm po-domain)
  (if (string? po-domain)
    (template scm
	      (replace-tag: "html" (lambda (options content)
				     `(html ,@options ,@content
					    ,(@ 'po-domain po-domain)))))
    scm))

;;; menu

(define (current-module? item url)
  (uri-prefix? (menu-item-ref item 'uri) url))

(define (find-module url module-data)
  (find (lambda(x) (current-module? x url))
        module-data))

(define (filter-module category module-data)
  (filter (lambda(x) (string=? category (menu-item-ref x 'category)))
        module-data))

(define (html:section group-name group-title items)
  (html: "div"
	 (@ 'class "menu-group")
	 (html: "div"
		(@ 'class "menu-group-name ui-corner-all")
		(@ 'title group-title)
		group-name)
	 items))

(define (html:module item url)
  (html: "div"
	 (@ 'class (if (current-module? item url) "menu-item-selected" "menu-item-normal"))
	 (html: "a" (@ 'href (menu-item-ref item 'uri))
                    (menu-item-ref item 'name))))

(define (menu-tag url sections-data module-data)
  (tag: "div" (@ 'id "menu")
	(filter-map (lambda(section)
		      (let ((modules (filter-module (menu-group-ref section 'category) module-data)))
			(and (pair? modules)
			     (html:section
			       (menu-group-ref section 'name)
			       (menu-group-ref section 'comment)
			       (map (lambda(item) (html:module item url))
			            modules)))))
		     sections-data)))

;;; main
(define (workflow url msg template-args)
  (let ((scm2 (or (string=? url "/" ) (process-module url msg))))
    (let* ((scm (cond-assq 'scm template-args))
	   (po-domain (and (pair? scm2) (find-po-domain scm2)))
	   (language (message-accept-language msg))

	   ;;new menu
	   (sections-data  (menu-list-group language))
	   (module-data (filter menu-item-html-ui? (menu-list-item language)))
	   (current-module (find-module url module-data))
	   (current-module-title (menu-item-ref current-module 'name)))
      (apply-po-domain
	(template scm
		  (head-tag scm2 current-module-title)
		  (title-tag current-module-title)
		  (menu-tag url sections-data module-data)
		  (main-tag scm2))
	po-domain))))
