(define-module (alterator workflow firsttime-finish)
	       :use-module (alterator algo)
	       :use-module (alterator ahttpd)
	       :use-module (alterator ajax)
	       :use-module (alterator http template)
	       :use-module (alterator http html)
	       :use-module (alterator woo)
	       :export (workflow))

(define (redirect-path msg)
  (let ((data (woo-read-first "/ahttpd-server")))
    (format #f "https://~A:~A"
	    (or (message-header msg "host") "localhost")
	    (woo-get-option data 'port "443"))))

(define (workflow url msg template-args)
  (begin-1
    (template (cond-assq 'scm template-args)
	      (replace-tag: "body"
			    (lambda (options content)
			      `(body ,@options
				     ,(html: "script"
					     (format #f "$(document).ready(function() {form_replace_if_ready(~A,3);});"
						     (->json (redirect-path msg))))
				     ,@content))))
    (woo "finish" "/firsttime")))

