(define-module (alterator workflow firsttime-framework)
    :use-module (srfi srfi-1)
    :use-module (srfi srfi-13)

    :use-module (alterator ahttpd)

    :use-module (alterator algo)
    :use-module (alterator woo)

    :use-module (alterator http template)
    :use-module (alterator http html)

    :use-module (alterator ahttpd translate)
    :use-module (alterator ahttpd html)
    :use-module (alterator ahttpd workflow)
  :export (workflow))

(define (scm-content scm name)
 (call-with-current-continuation
   (lambda(return)
    (template
      scm (tag: name (lambda (options content) (return content))))
    '())))

(define (main-tag scm)
  (and (pair? scm)
    (tag: "div" (@ 'id "main") (scm-content scm "body"))))

(define (title? x)
  (and (pair? x) (eq? (car x) 'title)))

(define (head-tag scm title)
  (and (pair? scm)
    (replace-tag: "head"
		  (lambda(options content)
		    (list 'head
			  (remove title? content)
			  (remove title? (scm-content scm "head"))
			  (html: "title" title))))))

(define (title-tag title)
    (tag: "span" (@ 'id "title") title))

(define (apply-po-domain scm po-domain)
  (if (string? po-domain)
    (template scm
	      (replace-tag: "html" (lambda (options content)
				     `(html ,@options ,@content
					    ,(@ 'po-domain po-domain)))))
    scm))

;;; main
(define (workflow uri msg template-args)
  (let* ((language (message-accept-language msg))
         (init-data (woo-read-first "/menu" 'language language 'ui "html" 'desktopfile "firsttime"))
	 (init-uri (woo-get-option init-data 'uri)))
    (if (or (uri-prefix? init-uri uri)
	    (uri-prefix? "/firsttime" uri))
      (let* ((scm (cond-assq 'scm template-args))
	     (scm2 (process-module uri msg))
	     (po-domain (and (pair? scm2) (find-po-domain scm2)))
	     (init-title (woo-get-option init-data 'name)))
	(apply-po-domain
	  (template scm
		    (head-tag scm2 init-title)
		    (title-tag init-title)
		    (main-tag scm2))
	  po-domain))
      (html:redirect init-uri))))
