(define-module (alterator workflow none)
    :use-module (alterator algo)
    :use-module (alterator ajax)
    :use-module (alterator http template)
    :use-module (alterator http html)
    :export (workflow))

(define (process-ajax uri scm)
  (template
    scm
    (replace-tag: "body" (lambda(options content)
			   `(body ,@options
				  (script ,(format #f "$(document).ready(function(){~A;});"
						   (make-ajax-text uri "init")))
				  ,@content)))))

;;; main
(define (workflow url msg template-args)
  (process-ajax
    url
    (cond-assq 'scm template-args)))
