(define-module (alterator workflow reload)
	       :use-module (alterator algo)
	       :use-module (alterator ahttpd)
	       :use-module (alterator http template)
	       :use-module (alterator http html)
	       :use-module (alterator woo)
	       :export (workflow))

(define (redirect-string msg)
  (let ((data (woo-read-first "/ahttpd-server")))
    (format #f "3;https://~A:~A~A"
	    (or (message-header msg "host") "localhost")
	    (woo-get-option data 'port "443")
	    "/ahttpd/server")))

(define (workflow url msg template-args)
  (begin-1
    (template (cond-assq 'scm template-args)
	      (replace-tag: "meta" (lambda (options content)
				     `(meta ,@options
					    (content . ,(redirect-string msg))))))
    (woo "reload" "/ahttpd-server")))

