
(function($){

function help_img_position(img, container)
{
    var offset= container.offset();
    img.css({ position: 'absolute',
	      top: (offset.top + 15)+'px',
	      left: (offset.left + container.innerWidth() - img.innerWidth() - 30) + 'px'});
}

function help_toggle(container,help_url)
{
    var popup = $('.ui-help-button',container);

    if (popup.length == 0)
    {
	popup = $('<div class="ui-help-button" style="display:none"></div>');
	content = $('<div class="ui-help-button-content" style="height:300px; overflow: auto">...</div>');
	popup.append(content);
	container.prepend(popup);

	content.load(help_url,
		     { url: document.location.pathname },
		     function() {
		        var img=$('<img class="close-dialog-button" src="/design/images/null.gif"/>')
			content.append(img);
			img.click(function() { help_toggle(container,help_url); });
			help_img_position(img,content)
			$(window).resize(function() { help_img_position(img,content);});
			return this;
		     });
	popup.resizable({ handles: 's'});
	popup.resize(function() {
			content.height(popup.height() - $('.ui-resizable-s',popup).outerHeight());
		    });
    }

    if (popup.is(':visible'))
	$('.close-dialog-button',popup).hide(10, function() { popup.slideUp('normal'); });
    else
	popup.slideDown('normal', function() { $('.close-dialog-button',popup).show(); });
}

$.fn.helpButton = function(container,help_url) {
    var userAgent = navigator.userAgent.toLowerCase();
    this.toggle(!/amc/.test( userAgent));
    this.click(function() { help_toggle(container,help_url); });
}

})(jQuery);
