var monthList = [   "January",
		    "February",
		    "March",
		    "April",
		    "May",
		    "June",
		    "July",
		    "August",
		   "September",
		   "October",
		   "November",
		   "December"  ];

var weekList = [ "Mo", "Tu", "We", "Th", "Fr", "Sa",  "Su" ];


(function($){

function elt_append(head)
{
    for(var i=1; i<arguments.length; i++)
	head = head.append(arguments[i]);
    return head;
}

function render_empty_day(day, today)
{
    return $('<td/>').addClass('day').append('&nbsp;');
}

function render_normal_day(day, today, cb)
{
    return $('<td/>').addClass((day == today)?'today':'day').text(day).click(cb);
}

function render_week()
{
    var out = $('<tr/>');

    for (var i = 0; i < 7; i++)
	out.append($('<td/>').addClass('week').text(weekList[i]));

    return out;
}

function render_year(month, year, prev_cb, next_cb)
{
    var out = $('<tr/>');

    var prev_button = $('<div/>').addClass('btn').text('<').click(prev_cb);
    var next_button = $('<div/>').addClass('btn').text('>').click(next_cb);

    var month_button = $('<span/>').addClass('month').text(monthList[month]);
    var year_button = $('<span/>').addClass('year').text(year);

    return  elt_append($('<tr/>'),
	elt_append($('<td/>'),prev_button),
	elt_append($('<td/>').attr('colSpan','5'),month_button,'&nbsp;',year_button),
	elt_append($('<td/>'),next_button));
}


var dayList = [ 31, -1 , 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];

function day_from_monday(date)
{
    var v = date.getDay() - 1;
    return (v < 0)? 6 : v;
}

function render_calendar(div, curDate, selectedDate, cb)
{

	function go_prev()
	{
	    render_calendar(div,
			    new Date(curDate.getFullYear(),
				curDate.getMonth()-1,
				1),
			    selectedDate,
			    cb);
	}

	function go_next()
	{
	    render_calendar(div,
			    new Date(curDate.getFullYear(),
				curDate.getMonth()+1,
				1),
			    selectedDate,
			    cb);
	}

	function go_select()
	{
	    var v=new Date(curDate.getFullYear(),
			   curDate.getMonth(),
			   $(this).text());

	    render_calendar(div,
			    curDate,
			    v,
			    cb);
	    cb(v);
	}

	var Month = curDate.getMonth();
	var Year = curDate.getFullYear();

	var today = 0;

	if ( Year == selectedDate.getFullYear() && Month == selectedDate.getMonth() )
		today = selectedDate.getDate();

	dayList[1] = ( ((Year%100 != 0) && (Year%4 == 0)) || (Year%400 == 0) ) ? 29 : 28;

	var out = $('<table/>').attr('cols', 7);

	out.append(render_year(Month,Year,go_prev,go_next));
	out.append(render_week());

	// Build days
	var weekDay = day_from_monday(curDate);

	for(var w = 0; w < 6; ++w)
	{
	  var week = $('<tr/>');
	  for (var d = 0 ; d < 7; ++d)
	  {
	    var i = 7*w + d + 1;
	    var day = i - weekDay;

	    if ( (day > 0) && (day <= dayList[Month]) )
		week.append(render_normal_day(day,today,go_select));
	    else
		week.append(render_empty_day());
	  }
	  out.append(week);
	}

	div.empty();
	div.append(out);
	div.bgIframe();
}

$.fn.calendar = function(selectedDate,callback) {
    return this.each(function() {
			render_calendar($(this),
					new Date(selectedDate.getFullYear(),
						 selectedDate.getMonth(),
						1),
					selectedDate,
					callback);
		});
}

function dateedit_number_string(n)
{
    return (n < 10)? '0'+n : n;
}

function dateedit_string(date)
{
    return date.getFullYear() +
	   '-' +
	   dateedit_number_string(date.getMonth()+1) +
	   '-' +
	   dateedit_number_string(date.getDate());
}

function dateedit_date(input)
{
    var v = input.val().split('-');

    if (v.length != 3)
	return new Date();
    else
	return new Date(v[0],v[1]-1,v[2]);
}


function do_toggle(input,div)
{
	div.toggle('fast');

	var offset = input.offset();

	div.css( { position: 'absolute',
	           left: offset.left+"px",
	           top: (offset.top+input.outerHeight())+"px",
	           zIndex: 10000 } );
}

$.fn.datepicker = function() {
	return this.each(function(){
			    var self=$(this);
			    var img=$('<img src="/design/images/datepicker.gif"/>');
			    var div=$('<div class="alterator-dateedit-calendar"/>');

			    img.insertAfter(self);
			    div.insertAfter(self);
			    do_toggle(self,div);

			    img.click(function() { do_toggle(self,div); });
			    self.bind('update-value',
				function() {
				    div.calendar(dateedit_date(self),
					 function(d) {
					   self.val(dateedit_string(d));
					   do_toggle(self,div);}); });
			    self.change(function() { self.trigger('update-value'); });
			    self.trigger('update-value');
			});
};

$.fn.dateedit = function() {
	return this.each(function(){
			    var self=$(this);
			    var container=$('<div/>');
			    var div=$('<div class="alterator-dateedit-calendar"/>');
			    self.wrap(container);
			    div.insertBefore(self);
			    $('<br/>').insertBefore(self);
			    self.bind('update-value',
				function() {
				    div.calendar(dateedit_date(self),
					function(d) { self.val(dateedit_string(d)); }); });
			    self.change(function() { self.trigger('update-value'); });
			    self.trigger('update-value');
			});
};

})(jQuery);
