(function($){

function clock_number_string(n)
{
    return (n < 10)? '0'+ n: n;
}

function clock_string(clock)
{
    var date = clock.now;
    var h = date.getHours();
    var m = date.getMinutes();
    var s = date.getSeconds();

    return clock_number_string(h) + ':' +
	   clock_number_string(m) + ':' +
	   clock_number_string(s);
}

function clock_date(input)
{
    var v = input.val().split(':');

    return new Date(1,1,1,
		    v[0] || 0,
		    v[1] || 0,
		    v[2] || 0);
}

function clock_update(clock,input)
{
    clock.now = clock_date(input);
    clock.refreshDisplay();

    input.val(clock_string(clock));
}

$.fn.timeedit = function() {
	return this.each(function(){
		    var self=$(this);

		    //create canvas widget
		    var name=self.attr('name');
		    var canvas_id=name+'-canvas';
		    var canvas=$('<canvas class="alterator-clock" id="'+canvas_id+'"/>');

		    if (!canvas[0].getContext) return;

		    //join into container
		    var container=$('<div/>');
		    self.wrap(container);
		    canvas.insertBefore(self);
		    $('<br/>').insertBefore(self);
		    $('<br/>').insertBefore(self);

		    //clock widget
		    var clock = this.clock = new CoolClock(canvas_id);
		    if (!clock) return;

		    //setup automatic update && freeze
		    var hasFocus = false;
		    var wasChanged = false;

		    clock.onTick = function() { if (!hasFocus && !wasChanged) self.val(clock_string(this)); }
		    self.bind('update-value',function() { clock_update(clock,self); });
		    self.focus(function() { hasFocus = true; clock.stop(); });
		    self.blur(function() { hasFocus = false; if (!wasChanged) clock.start(); });
		    self.change(function() { wasChanged = true; self.trigger('update-value'); });

		    self.trigger('update-value');
		});
};

})(jQuery);
