(define-module (alterator wizard)
    :use-module (alterator ajax)
    :use-module (alterator context)
    :use-module (alterator lookout goto)
    :use-module (alterator lookout globals)
    :use-module (alterator lookout attributes)
    :export (
	    ;;API for main workflow
	    wizardface-context-set!
	    wizardface-context-ref
	    ;;API for steps
	    wizard?
	    wizard-bind
	    wizard-unbind
	    wizard-unbind-all
	    wizard-call
	    wizard-update-activity
	    wizard-branch
	    ;;deprecated API
	    frame:next-activity
	    frame:back-activity
	    frame:on-next
	    frame:on-back
	    ))


;;; wizardface API

;;wizardface context, to access all wizardface widgets

(define *wizardface-context* #f)
(define *wizardface-name* "wizardface")

(define (wizardface-context-set!)
    (set-global! 'frame:next #t)
    (set! *wizardface-context* (fluid-ref lookout-context)))

(define (wizardface-context-ref) *wizardface-context*)

(define (wizardface)
  (and *wizardface-context*
       (with-context *wizardface-context*
           (let ((document (global 'document:root)))
              (cond-car (form-get-elements-by-name document *wizardface-name*))))))

;; wizard step's API

(define *wizardface-callbacks* (make-hash-table 20))

(define (wizard?) *wizardface-context*)

(define (wizard-bind name proc)
 (let ((ctxt (fluid-ref lookout-context)))
  (hash-set! *wizardface-callbacks*
             name
             (lambda() (with-context ctxt (proc))))))

(define (wizard-unbind name)
 (hash-remove! *wizardface-callbacks* name))

(define (wizard-unbind-all)
 (set! *wizardface-callbacks* (make-hash-table 20)))

(define (wizard-call name)
  (let ((proc (hash-ref *wizardface-callbacks* name)))
    (and (procedure? proc) (proc))))

(define (wizard-action name)
  (cond
    ((string=? name "next") 'forward)
    ((string=? name "previous") 'backward)
    ((string=? name "finish") 'finish)
    (else (error (format #f "unknown wizardface's action name ~A" name)))))

(define (wizard-update-activity name status)
 (and *wizardface-context*
   (with-context *wizardface-context*
      (let ((document (global 'document:root)))
        (form-element-apply document *wizardface-name* action-activity (wizard-action name) status)))))

;;start new wizard branch
(define (wizard-branch steps-file)
  (and *wizardface-context*
       (with-context *wizardface-context*
          (document:replace "/wizard" 'steps-file steps-file))))

(define (frame:set-activity name value)
  (frame:call-global 'frame:wizard action-activity name value))

;; deprecated

(define (frame:next-activity value)
  (format
    (current-error-port)
    "frame:next-activity is deprecated, use wizard-update-activity instead~%")
  (wizard-update-activity "next" value)
  (wizard-update-activity "finish" value))

(define (frame:back-activity value)
  (format
    (current-error-port)
    "frame:back-activity is deprecated, use wizard-update-activity instead~%")
  (wizard-update-activity "previous" value))

(define (frame:on-next proc)
  (format
    (current-error-port)
    "frame:on-next is deprecated, use wizard-bind instead~%")
  (wizard-bind "next" proc))

(define (frame:on-back proc)
  (format
    (current-error-port)
    "frame:on-back is deprecated, use wizard-bind instead~%")
  (wizard-bind "previous" proc))
